;*****************************************************************************
;
;            MARCO STROPPA: APPLICATIONS OF CSOUND
;
;	ADDITIVE SYNTHESIS INSTRUMENT N. 11
;		TYPE 1 : COMPLETE INSTRUMENT (INCLUDING AMP AND FREQ MODULES)
;-----------------------------------------------------------------------------
;	p1	instrument number 11
;	p2	action time [sec]
;	p3	duration [sec]
;	p4	global amplitude [0:1]
;	p5	frequency [Hz]
;	p6	stereo balance   [0 = left / 1 = right]
;	p7	jitter amplitude, with internal perceptual compensation [0:1]
;	p8	tremolo amplitude, with internal perceptual compensation [0:1]
;	p9	tremolo frequency [Hz]
;	p10	attack duration [sec]
;	p11	decay duration [sec], with internal readjustment if needed
;	p12 	function number for amplitude envelope
;	p13	balance freq.jitter/vibrato [1 = jitter / 0 = vibrato]
;	p14	vibrato frequency [Hz]
;	p15	frequency deviation [semitones]
;	p16	function number for frequency envelope
;	p17	portato amplitude [semitones]
;	p18	function number for portato envelope
;	p19	portato duration [sec]
;-----------------------------------------------------------------------------
; COMPULSORY FUNCTIONS :
;	f1	audio sine wave
;	f2	vibrato
;	f3	tremolo
;************************************************************************

; Globals

	sr     = 16000
	kr     = 2000
	ksmps  = 8
	nchnls = 2

	giramp = 1.0 / 3.0	; Some constants for a good jitter
	girfq1 = 20.134		; from a model described in Chant
	girfq2 = 9.109
	girfq3 = 0.821

	gimxamp= 32767

	gibal  = 2.13		; Factor to balance rms of jit/vib(trem)
				; (See below)


instr 11

			; Initialization	
			; --------------


		idurosc   = 	1.0 / p3
		igbamp	  =	gimxamp * p4
		ifroct	  =     octcps( p5 )

; if att+dec > dur, reajust dec, but keep att the same
		idec	  =	( p10 + p11 <= p3 ? p11 : p3-p10 )
; if att >= dur, put, by default, att = dec = 1/2*dur (no undesirable clicks)
		iatt	  =	( idec >= 0 ? p10 : p3/2)
		idec	  =	( idec >= 0 ? idec : p3/2 )

; old version	idec	  =	( p10 + p11 <= p3 ? p11 : p3-p10 )

		ifdev	  =  	p15 / 12	   ; octave representation
		ifprt	  =	p17 / 12	   ; (1 = octave)

						   ; corrections on 
						   ; jitter/tremolo (vibrato)
		if   p13 != 1   goto else1	   ; amplitude factors, to
		ifjit	  =	ifdev		   ; compensate perceptual
		ifvib	  =	0		   ; energy.
		goto 	cont1
else1:
		idivf	  =	p13 / (1 - p13)
		ifp13     =	idivf * gibal / (idivf * gibal + 1)
		ifjit	  = 	(ifp13 >= 1 ? ifdev : ifdev * ifp13)
		ifvib	  = 	ifdev * (1 - ifp13)
cont1:
		isuma	  =  	abs(p7) + abs(p8); amplitude is absolute
		if   p7*p8 !=0  goto else2
		iajit	  =	p7 * gibal * igbamp
							  ; avoid overflow
		iajit	  =	(abs(iajit) > gimxamp ? gimxamp : iajit)
		iatrm	  =	p8 * igbamp
		iatrm	  =	(abs(iatrm) > gimxamp ? gimxamp : iatrm)
		goto cont2
else2:
		isignp7	  =	(p7 < 0.0 ? -1 : 1)
		isignp8	  =	(p8 < 0.0 ? -1 : 1)
		idiva	  =     abs(p7) / abs(p8)
		iap7	  =	isuma * idiva * gibal / (idiva * gibal + 1)
		iap8	  =	isuma - iap7
		iajit	  = 	igbamp * iap7 * isignp7
		iajit	  =	(abs(iajit) > gimxamp ? gimxamp : iajit)
		iatrm	  =	igbamp * iap8 * isignp8
		iatrm	  =	(abs(iatrm) > gimxamp ? gimxamp : iatrm)
cont2:
	        imod      = 	 abs(iajit) + abs(iatrm)
        	if imod  <= 	igbamp goto cont3	; too much modulation
		imodscal  = 	igbamp/imod	        ; reduce it keeping
		iajit	  = 	iajit * imodscal	; ratio jit/trem
		iatrm	  = 	iatrm * imodscal
cont3:
		iamprel   =	( igbamp-imod < 0.0 ? 0.0 : igbamp-imod )



				;--- Amplitude ---
				;    ---------


	; Jitter module

		kaj1	randi	giramp,girfq1,-1
		kaj2	randi	giramp,girfq2,-1
		kaj3	randi	giramp,girfq3,-1

		kajit     =	(kaj1 + kaj2 + kaj3) * iajit

	; Tremolo module

		katrm	oscili	iatrm,p9,3

	; Amplitude modulation

		kamod	  =	kajit + katrm + iamprel

	; Amplitude envelope

		kaenv   oscili 	kamod,idurosc,p12

	; Global amplitude envelope

		kamp 	linen 	kaenv,p10,p3,idec


				;--- Frequency ---
				;    ---------


	; Jitter module

		kfj1	randi	giramp,girfq1,-1
		kfj2	randi	giramp,girfq2,-1
		kfj3	randi	giramp,girfq3,-1

		kfjit     =	(kfj1 + kfj2 + kfj3) * ifjit

	; Vibrato module

		kfvib	oscili	ifvib,p14,2

	; Portato module

		kfprt	oscil1i	0,ifprt,p19,p18

	; Frequency "modulation"

		kfmod	  =	kfjit + kfvib + kfprt

	; Frequency envelope

		kfenv   oscili 	kfmod,idurosc,p16

	; Global frequency 

		kfrq	  =	cpsoct( kfenv + ifroct )


		        ;--- Main oscillator / panning ---
			;    ---------------   -------



		asig 	oscili 	kamp,kfrq,1
		al	  =	asig * (1 - p6)
		ar	  =	asig - al
		outs		al,ar

endin
