;***************************************************************************
;
;            MARCO STROPPA: APPLICATIONS OF CSOUND
;
; COMPUTABLE CSOUND SCORE MADE OF THE MOLD SCORE + FUNCTIONS + ENVELOPES
;      ADDED COMMENTS ARE BETWEEN LINES OF ASTERISKS
;      THE REST IS PRODUCED BY THE SYSTEM
;***************************************************************************
;
; SCORE GOING WITH ORCHESTRA ADD1.orc
; TO RUN IT :
; 	 csound ADD1.orc exmpl.sco
;***************************************************************************

;***************************************************************************
; METRONOME SET TO 60 FOR THE WHOLE SCORE (BEATS = SECONDS)
;***************************************************************************
w 0 60

;***************************************************************************
; SINE-TONE FUNCTIONS FOR AUDIO AND MODULATION MODULES
;***************************************************************************
f 1 0 0 4097 4097 10 1
f 2 0 0 4097 4097 10 1
f 3 0 0 4097 4097 10 1

;***************************************************************************
; DATA BASE OF ENVELOPES
; FIRST SET
;***************************************************************************
f 1001 0 0 513 513 7 0 56 1 46 .6 257 .6 154 0
f 1002 0 0 513 513 7 0 103 1 51 .6 206 .6 153 0
f 1003 0 0 513 513 7 0 103 1 103 .6 154 .6 153 0
f 1004 0 0 513 513 7 0 154 1 51 .6 154 .6 154 0
f 1005 0 0 513 513 7 0 139 1 108 .6 164 .6 102 0
f 1006 0 0 513 513 7 0 56 1 46 .4 205 .4 206 0
f 1007 0 0 513 513 7 0 103 1 51 .4 210 .4 149 0
f 1008 0 0 513 513 7 0 97 1 108 .32 205 .3 103 0
f 1009 0 0 513 513 7 0 154 1 51 .27 108 .27 200 0
f 1010 0 0 513 513 7 0 154 1 103 .29 123 .23 133 0
f 1011 0 0 513 513 7 0 15 .61 22 .27 25 1 46 .38 26 .64 46 .48 171 .4 162 0
f 1012 0 0 513 513 7 0 18 .27 32 .18 13 .591 26 .33 24 1 53 .4 96 .4 29 .582 26 .24 59 .43 137 0
f 1013 0 0 513 513 7 0 21 .582 31 .23 34 .37 21 .12 27 1 62 .33 144 .28 27 .48 25 .09 46 .27 75 0
f 1014 0 0 513 513 7 0 26 .52 36 .32 31 .691 21 .18 41 1 51 .37 31 .55 31 .16 21 .23 103 .2 36 .35 30 .061 55 0
f 1015 0 0 513 513 7 0 24 .35 31 .11 99 1 46 .31 21 .49 41 .17 56 .29 72 .33 21 .41 41 .11 31 .2 30 0
f 1016 0 0 513 513 7 0 46 1 41 .3 21 .52 21 .05 31 .39 31 .24 149 .2 21 .43 25 .11 37 .28 90 0
f 1017 0 0 513 513 7 0 25 .73 30 .17 16 .43 23 .19 24 1 51 .33 174 .26 21 .48 31 .11 19 .35 27 .15 28 .22 44 0
f 1018 0 0 513 513 7 0 33 .67 21 .22 29 .42 21 .14 41 1 46 .3 171 .2 151 0
f 1019 0 0 513 513 7 0 33 .88 23 .3 39 .55 18 .17 31 .3 29 .11 48 1 36 .3 163 .25 27 .48 66 0
f 1020 0 0 513 513 7 0 19 .77 31 .18 104 1 51 .35 144 .3 41 .52 21 .14 102 0
f 1021 0 0 513 513 7 0 19 .62 22 .21 21 1 31 .4 215 .4 205 0
f 1022 0 0 513 513 7 0 23 .53 19 .23 22 1 69 .3 174 .3 31 .6 41 .11 134 0
f 1023 0 0 513 513 7 0 9 .681 16 .24 47 1 46 .37 175 .31 220 0
f 1024 0 0 513 513 7 0 4 .63 15 .19 37 1 62 .3 139 .24 21 .52 28 .16 23 .65 46 .22 87 .08 51 0
f 1025 0 0 513 513 7 0 7 .42 25 .15 41 1 46 .27 292 .22 102 0
f 1026 0 0 513 513 7 0 4 .6 14 .2 35 1 49 .2 21 .52 26 .25 212 .25 152 0
f 1027 0 0 513 513 7 0 7 .43 9 .25 46 1 41 .27 21 .52 23 .12 18 .38 21 .2 175 .17 14 .42 15 .12 26 .27 46 .061 51 0
f 1028 0 0 513 513 7 0 11 .571 14 .2 38 1 43 .35 254 .21 15 .42 14 .15 33 .581 34 .11 57 0
f 1029 0 0 513 513 7 0 9 .5 18 .2 32 1 23 .27 26 .45 26 .25 174 .2 15 .55 32 .15 14 .37 36 .2 17 .3 40 .05 51 0
f 1030 0 0 513 513 7 0 11 .4 21 .17 34 1 41 .38 186 .25 24 .42 36 .17 30 .4 62 .101 68 0
f 1031 0 0 513 513 7 0 21 .78 36 .3 41 1 41 .55 165 .2 46 .48 25 .17 48 .28 90 0
f 1032 0 0 513 513 7 0 5 .6 14 .28 17 1 31 .5 190 .2 256 0
f 1033 0 0 513 513 7 0 9 .43 26 .17 26 .681 26 .4 23 1 44 .52 209 .37 37 .5 36 .11 77 0
f 1034 0 0 513 513 7 0 12 .45 31 .22 22 1 45 .47 218 .22 31 .41 30 .17 37 .21 87 0
f 1035 0 0 513 513 7 0 19 .681 37 .35 36 1 41 .39 26 .49 215 .32 139 0
f 1036 0 0 513 513 7 0 15 .4 16 .22 40 1 42 .19 231 .31 22 .17 40 .55 46 .15 61 0
f 1037 0 0 513 513 7 0 10 .6 43 .3 34 .75 26 .2 41 1 46 .2 169 .581 31 .14 21 .39 46 .061 46 0
f 1038 0 0 513 513 7 0 15 .66 23 .37 54 1 26 .38 195 .55 26 .19 41 .38 36 .12 97 0
f 1039 0 0 513 513 7 0 15 .48 23 .32 38 1 46 .3 72 .47 93 .15 226 0
f 1040 0 0 513 513 7 0 15 .52 31 .2 21 .8 36 .37 51 1 51 .2 169 .4 36 .2 26 .55 47 .08 30 0
f 1051 0 0 513 513 7 1 56 1 46 .6 257 .6 154 0
f 1052 0 0 513 513 7 1 103 1 51 .6 206 .6 153 0
f 1053 0 0 513 513 7 1 103 1 103 .6 154 .6 153 0
f 1054 0 0 513 513 7 1 154 1 51 .6 154 .6 154 0
f 1055 0 0 513 513 7 1 139 1 108 .6 164 .6 102 0
f 1056 0 0 513 513 7 1 56 1 46 .4 205 .4 206 0
f 1057 0 0 513 513 7 1 103 1 51 .4 210 .4 149 0
f 1058 0 0 513 513 7 1 97 1 108 .32 205 .3 103 0
f 1059 0 0 513 513 7 1 154 1 51 .27 108 .27 200 0
f 1060 0 0 513 513 7 1 154 1 103 .29 123 .23 133 0
f 1061 0 0 513 513 7 1 37 .27 25 1 46 .38 26 .64 46 .48 171 .4 162 0
f 1062 0 0 513 513 7 1 50 .18 13 .591 26 .33 24 1 53 .4 96 .4 29 .582 26 .24 59 .43 137 0
f 1063 0 0 513 513 7 1 52 .23 34 .37 21 .12 27 1 62 .33 144 .28 27 .48 25 .09 46 .27 75 0
f 1064 0 0 513 513 7 1 62 .32 31 .691 21 .18 41 1 51 .37 31 .55 31 .16 21 .23 103 .2 36 .35 30 .061 55 0
f 1065 0 0 513 513 7 1 55 .11 99 1 46 .31 21 .49 41 .17 56 .29 72 .33 21 .41 41 .11 31 .2 30 0
f 1066 0 0 513 513 7 1 46 1 41 .3 21 .52 21 .05 31 .39 31 .24 149 .2 21 .43 25 .11 37 .28 90 0
f 1067 0 0 513 513 7 1 55 .17 16 .43 23 .19 24 1 51 .33 174 .26 21 .48 31 .11 19 .35 27 .15 28 .22 44 0
f 1068 0 0 513 513 7 1 53 .22 29 .42 21 .14 41 1 46 .3 171 .2 152 0
f 1069 0 0 513 513 7 1 113 .17 31 .3 29 .11 48 1 36 .3 163 .25 27 .48 66 0
f 1070 0 0 513 513 7 1 50 .18 104 1 51 .35 144 .3 41 .52 21 .14 102 0
f 1071 0 0 513 513 7 1 41 .21 21 1 31 .4 215 .4 205 0
f 1072 0 0 513 513 7 1 42 .23 22 1 69 .3 174 .3 31 .6 41 .11 134 0
f 1073 0 0 513 513 7 1 25 .24 47 1 46 .37 175 .31 220 0
f 1074 0 0 513 513 7 1 19 .19 37 1 62 .3 139 .24 21 .52 28 .16 23 .65 46 .22 87 .08 51 0
f 1075 0 0 513 513 7 1 31 .15 41 1 46 .27 292 .22 103 0
f 1076 0 0 513 513 7 1 53 1 49 .2 21 .52 26 .25 212 .25 152 0
f 1077 0 0 513 513 7 1 62 1 41 .27 21 .52 23 .12 18 .38 21 .2 175 .17 14 .42 15 .12 26 .27 46 .061 51 0
f 1078 0 0 513 513 7 1 63 1 43 .35 254 .21 15 .42 14 .15 33 .581 34 .11 57 0
f 1079 0 0 513 513 7 1 59 1 23 .27 26 .45 26 .25 174 .2 15 .55 32 .15 14 .37 36 .2 17 .3 40 .05 51 0
f 1080 0 0 513 513 7 1 67 1 41 .38 186 .25 24 .42 36 .17 30 .4 62 .101 67 0
f 1081 0 0 513 513 7 1 56 .3 41 1 41 .55 165 .2 46 .48 25 .17 48 .28 91 0
f 1082 0 0 513 513 7 1 36 1 31 .5 190 .2 256 0
f 1083 0 0 513 513 7 1 35 .17 26 .681 26 .4 23 1 44 .52 209 .37 37 .5 36 .11 77 0
f 1084 0 0 513 513 7 1 44 .22 22 1 45 .47 218 .22 31 .41 30 .17 37 .21 86 0
f 1085 0 0 513 513 7 1 56 .35 36 1 41 .39 26 .49 215 .32 139 0
f 1086 0 0 513 513 7 1 31 .22 40 1 42 .19 231 .31 22 .17 40 .55 46 .15 61 0
f 1087 0 0 513 513 7 1 53 .3 34 .75 26 .2 41 1 46 .2 169 .581 31 .14 21 .39 46 .061 46 0
f 1088 0 0 513 513 7 1 38 .37 54 1 26 .38 195 .55 26 .19 41 .38 36 .12 97 0
f 1089 0 0 513 513 7 1 38 .32 38 1 46 .3 72 .47 93 .15 226 0
f 1090 0 0 513 513 7 1 46 .2 21 .8 36 .37 51 1 51 .2 169 .4 36 .2 26 .55 47 .08 30 0

;***************************************************************************
; SECOND SET
;***************************************************************************
f 1201 0 0 513 513 7 1 513 1
f 1202 0 0 513 513 7 0 513 0
f 1203 0 0 513 513 7 0 56 .33 87 .48 113 .53 104 .581 91 .691 62 1
f 1204 0 0 513 513 7 1 62 .691 92 .581 103 .53 113 .48 87 .33 56 0
f 1205 0 0 513 513 7 -1 62 -.691 92 -.581 103 -.53 113 -.48 87 -.33 56 0
f 1206 0 0 513 513 7 0 56 -.33 87 -.48 113 -.53 104 -.581 91 -.691 62 -1
f 1211 0 0 513 513 7 1 513 1
f 1212 0 0 513 513 7 0 257 1 256 0

;***************************************************************************
; SCORE SORTED IN TIME
;	p1	instrument number 11
;	p2	action time [sec]
;	p3	duration [sec]
;	p4	global amplitude [0:1]
;	p5	frequency [Hz]
;	p6	stereo balance   [0 = left / 1 = right]
;	p7	jitter amplitude, with internal perceptual compensation [0:1]
;	p8	tremolo amplitude, with internal perceptual compensation [0:1]
;	p9	tremolo frequency [Hz]
;	p10	attack duration [sec]
;	p11	decay duration [sec], with internal readjustment if needed
;	p12 	function number for amplitude envelope
;	p13	balance freq.jitter/vibrato [1 = jitter / 0 = vibrato]
;	p14	vibrato frequency [Hz]
;	p15	frequency deviation [semitones]
;	p16	function number for frequency envelope
;	p17	portato amplitude [semitones]
;	p18	function number for portato envelope
;	p19	portato duration [sec]
;***************************************************************************

i 11 1 1 .5854 .5854 0.00013 2352.0 0.500 -0.00 0.004 4.2384 0.0000 0.5000 1030 0.680 6.1285 0.0000 1202 0.0000 1205 0.02887
i 11 1 1 1.1708 1.1708 0.00013 2408.1 0.500 -0.00 0.004 4.2384 0.0000 0.5000 1030 0.680 6.1285 0.0000 1202 0.0000 1205 0.02887
i 11 1 1 1.1708 1.1708 0.00013 2334.5 0.500 -0.00 0.004 4.2384 0.0000 0.5000 1030 0.680 6.1285 0.0000 1202 0.0000 1205 0.02887
i 11 1 1 1.1708 1.1708 0.00013 2274.3 0.500 -0.00 0.004 4.2384 0.0000 0.5000 1030 0.680 6.1285 0.0000 1202 0.0000 1205 0.02887
i 11 1 1 1.1708 1.1708 0.00013 2338.6 0.500 -0.00 0.004 4.2384 0.0000 0.5000 1030 0.680 6.1285 0.0000 1202 0.0000 1205 0.02887
i 11 1.02364 1.02364 .76168 .76168 0.09100 1411.2 0.500 0.026 0.017 5.7475 0.0000 0.5000 1030 0.791 5.9156 0.0000 1202 0.0000 1205 0.03723
i 11 1.02364 1.02364 .91155 .91155 0.03249 1419.3 0.500 0.026 0.017 5.7475 0.0000 0.5000 1030 0.791 5.9156 0.0000 1202 0.0000 1205 0.03723
i 11 1.02364 1.02364 .91155 .91155 0.03249 1371.4 0.500 0.026 0.017 5.7475 0.0000 0.5000 1030 0.791 5.9156 0.0000 1202 0.0000 1205 0.03723
i 11 1.02364 1.02364 .91155 .91155 0.03249 1407.6 0.500 0.026 0.017 5.7475 0.0000 0.5000 1030 0.791 5.9156 0.0000 1202 0.0000 1205 0.03723
i 11 1.0375 1.0375 .71711 .71711 0.05783 232.28 0.500 -0.02 0.007 5.7136 0.0000 0.5000 1028 0.700 5.2007 0.0000 1202 0.0000 1205 0.04123
i 11 1.0375 1.0375 .71711 .71711 0.05783 238.77 0.500 -0.02 0.007 5.7136 0.0000 0.5000 1028 0.700 5.2007 0.0000 1202 0.0000 1205 0.04123
i 11 1.0375 1.0375 .71711 .71711 0.05783 236.11 0.500 -0.02 0.007 5.7136 0.0000 0.5000 1028 0.700 5.2007 0.0000 1202 0.0000 1205 0.04123
i 11 1.0375 1.0375 .71711 .71711 0.05783 233.96 0.500 -0.02 0.007 5.7136 0.0000 0.5000 1028 0.700 5.2007 0.0000 1202 0.0000 1205 0.04123
i 11 1.0375 1.0375 .83419 .83419 0.05783 235.20 0.500 -0.02 0.007 5.7136 0.0000 0.5000 1028 0.700 5.2007 0.0000 1202 0.0000 1205 0.04123
i 11 1.03777 1.03777 .66671 .66671 0.07906 2153.8 0.500 -0.03 0.020 7.2988 0.0000 0.5000 1029 0.683 7.4372 0.0000 1202 0.0000 1205 0.04499
i 11 1.03777 1.03777 .66671 .66671 0.07906 2155.5 0.500 -0.03 0.020 7.2988 0.0000 0.5000 1029 0.683 7.4372 0.0000 1202 0.0000 1205 0.04499
i 11 1.03777 1.03777 .66671 .66671 0.07906 2145.5 0.500 -0.03 0.020 7.2988 0.0000 0.5000 1029 0.683 7.4372 0.0000 1202 0.0000 1205 0.04499
i 11 1.03777 1.03777 .91413 .91413 0.09510 2116.8 0.500 -0.03 0.020 7.2988 0.0000 0.5000 1029 0.683 7.4372 0.0000 1202 0.0000 1205 0.04499
i 11 1.04379 1.04379 .47947 .47947 0.05989 1189.1 0.500 0.066 0.012 7.1308 0.0000 0.5000 1031 0.929 7.1138 0.0000 1202 0.0000 1205 0.05188
i 11 1.04379 1.04379 .47947 .47947 0.05989 1172.0 0.500 0.066 0.012 7.1308 0.0000 0.5000 1031 0.929 7.1138 0.0000 1202 0.0000 1205 0.05188
i 11 1.04379 1.04379 .47947 .47947 0.05989 1157.5 0.500 0.066 0.012 7.1308 0.0000 0.5000 1031 0.929 7.1138 0.0000 1202 0.0000 1205 0.05188
i 11 1.04379 1.04379 1.04346 1.04346 0.10323 1176.0 0.500 0.066 0.012 7.1308 0.0000 0.5000 1031 0.929 7.1138 0.0000 1202 0.0000 1205 0.05188
i 11 1.04522 1.04522 .67751 .67751 0.09263 1618.7 0.500 0.014 0.007 5.0303 0.0000 0.5000 1035 0.676 7.5947 0.0000 1202 0.0000 1205 0.04538
i 11 1.04522 1.04522 .67751 .67751 0.09263 1649.1 0.500 0.014 0.007 5.0303 0.0000 0.5000 1035 0.676 7.5947 0.0000 1202 0.0000 1205 0.04538
i 11 1.04522 1.04522 .67751 .67751 0.09263 1617.0 0.500 0.014 0.007 5.0303 0.0000 0.5000 1035 0.676 7.5947 0.0000 1202 0.0000 1205 0.04538
i 11 1.04522 1.04522 .67751 .67751 0.09263 1659.4 0.500 0.014 0.007 5.0303 0.0000 0.5000 1035 0.676 7.5947 0.0000 1202 0.0000 1205 0.04538
i 11 1.04522 1.04522 .89964 .89964 0.04973 1646.4 0.500 0.014 0.007 5.0303 0.0000 0.5000 1035 0.676 7.5947 0.0000 1202 0.0000 1205 0.04538
i 11 1.0722 1.0722 .58749 .58749 0.12754 697.79 0.500 0.096 0.018 9.0082 0.0000 0.5000 1027 0.763 4.5044 0.0000 1202 0.0000 1205 0.04551
i 11 1.0722 1.0722 .58749 .58749 0.12754 697.29 0.500 0.096 0.018 9.0082 0.0000 0.5000 1027 0.763 4.5044 0.0000 1202 0.0000 1205 0.04551
i 11 1.0722 1.0722 .58749 .58749 0.12754 708.64 0.500 0.096 0.018 9.0082 0.0000 0.5000 1027 0.763 4.5044 0.0000 1202 0.0000 1205 0.04551
i 11 1.0722 1.0722 .92028 .92028 0.10369 705.60 0.500 0.096 0.018 9.0082 0.0000 0.5000 1027 0.763 4.5044 0.0000 1202 0.0000 1205 0.04551
i 11 1.5 1.5 .57053 .57053 0.00013 2413.1 0.542 0.080 0.019 8.0332 0.0000 0.5000 1034 0.938 7.3692 0.0000 1202 0.0000 1205 0.02886
i 11 1.5 1.5 1.14107 1.14107 0.00013 2468.9 0.542 0.080 0.019 8.0332 0.0000 0.5000 1034 0.938 7.3692 0.0000 1202 0.0000 1205 0.02886
i 11 1.5 1.5 1.14107 1.14107 0.00013 2396.7 0.542 0.080 0.019 8.0332 0.0000 0.5000 1034 0.938 7.3692 0.0000 1202 0.0000 1205 0.02886
i 11 1.5 1.5 1.14107 1.14107 0.00013 2479.0 0.542 0.080 0.019 8.0332 0.0000 0.5000 1034 0.938 7.3692 0.0000 1202 0.0000 1205 0.02886
i 11 1.5 1.5 1.14107 1.14107 0.00013 2337.4 0.542 0.080 0.019 8.0332 0.0000 0.5000 1034 0.938 7.3692 0.0000 1202 0.0000 1205 0.02886
i 11 1.52251 1.52251 .783 .783 0.08856 1472.3 0.392 0.010 0.010 6.2984 0.0000 0.5000 1029 0.676 4.0705 0.0000 1202 0.0000 1205 0.03865
i 11 1.52251 1.52251 .88512 .88512 0.03251 1474.5 0.392 0.010 0.010 6.2984 0.0000 0.5000 1029 0.676 4.0705 0.0000 1202 0.0000 1205 0.03865
i 11 1.52251 1.52251 .88512 .88512 0.03251 1463.8 0.392 0.010 0.010 6.2984 0.0000 0.5000 1029 0.676 4.0705 0.0000 1202 0.0000 1205 0.03865
i 11 1.52251 1.52251 .88512 .88512 0.03251 1440.8 0.392 0.010 0.010 6.2984 0.0000 0.5000 1029 0.676 4.0705 0.0000 1202 0.0000 1205 0.03865
i 11 1.5375 1.5375 .69316 .69316 0.05786 301.09 0.473 -0.01 0.015 6.4041 0.0000 0.5000 1030 0.807 8.0698 0.0000 1202 0.0000 1205 0.04125
i 11 1.5375 1.5375 .69316 .69316 0.05786 292.96 0.473 -0.01 0.015 6.4041 0.0000 0.5000 1030 0.807 8.0698 0.0000 1202 0.0000 1205 0.04125
i 11 1.5375 1.5375 .69316 .69316 0.05786 300.29 0.473 -0.01 0.015 6.4041 0.0000 0.5000 1030 0.807 8.0698 0.0000 1202 0.0000 1205 0.04125
i 11 1.5375 1.5375 .69316 .69316 0.05786 291.66 0.473 -0.01 0.015 6.4041 0.0000 0.5000 1030 0.807 8.0698 0.0000 1202 0.0000 1205 0.04125
i 11 1.5375 1.5375 .81301 .81301 0.05786 296.33 0.473 -0.01 0.015 6.4041 0.0000 0.5000 1030 0.807 8.0698 0.0000 1202 0.0000 1205 0.04125
i 11 1.53843 1.53843 .6434 .6434 0.07910 2136.4 0.387 0.001 0.007 7.8611 0.0000 0.5000 1027 0.679 5.8492 0.0000 1202 0.0000 1205 0.04176
i 11 1.53843 1.53843 .6434 .6434 0.07910 2176.6 0.387 0.001 0.007 7.8611 0.0000 0.5000 1027 0.679 5.8492 0.0000 1202 0.0000 1205 0.04176
i 11 1.53843 1.53843 .6434 .6434 0.07910 2192.6 0.387 0.001 0.007 7.8611 0.0000 0.5000 1027 0.679 5.8492 0.0000 1202 0.0000 1205 0.04176
i 11 1.53843 1.53843 .83884 .83884 0.09418 2177.9 0.387 0.001 0.007 7.8611 0.0000 0.5000 1027 0.679 5.8492 0.0000 1202 0.0000 1205 0.04176
i 11 1.54447 1.54447 .65406 .65406 0.09267 1665.8 0.443 0.063 0.012 5.2893 0.0000 0.5000 1031 0.869 4.9781 0.0000 1202 0.0000 1205 0.04682
i 11 1.54447 1.54447 .65406 .65406 0.09267 1699.1 0.443 0.063 0.012 5.2893 0.0000 0.5000 1031 0.869 4.9781 0.0000 1202 0.0000 1205 0.04682
i 11 1.54447 1.54447 .65406 .65406 0.09267 1739.5 0.443 0.063 0.012 5.2893 0.0000 0.5000 1031 0.869 4.9781 0.0000 1202 0.0000 1205 0.04682
i 11 1.54447 1.54447 .65406 .65406 0.09267 1677.4 0.443 0.063 0.012 5.2893 0.0000 0.5000 1031 0.869 4.9781 0.0000 1202 0.0000 1205 0.04682
i 11 1.54447 1.54447 .93632 .93632 0.05086 1707.5 0.443 0.063 0.012 5.2893 0.0000 0.5000 1031 0.869 4.9781 0.0000 1202 0.0000 1205 0.04682
i 11 1.54605 1.54605 .45855 .45855 0.05992 1239.0 0.454 0.045 0.021 6.7525 0.0000 0.5000 1027 0.644 7.8400 0.0000 1202 0.0000 1205 0.04259
i 11 1.54605 1.54605 .45855 .45855 0.05992 1215.7 0.454 0.045 0.021 6.7525 0.0000 0.5000 1027 0.644 7.8400 0.0000 1202 0.0000 1205 0.04259
i 11 1.54605 1.54605 .45855 .45855 0.05992 1232.2 0.454 0.045 0.021 6.7525 0.0000 0.5000 1027 0.644 7.8400 0.0000 1202 0.0000 1205 0.04259
i 11 1.54605 1.54605 .83839 .83839 0.10527 1237.1 0.454 0.045 0.021 6.7525 0.0000 0.5000 1027 0.644 7.8400 0.0000 1202 0.0000 1205 0.04259
i 11 1.56632 1.56632 .56519 .56519 0.12760 765.58 0.384 -0.01 0.013 7.2144 0.0000 0.5000 1033 0.767 5.4019 0.0000 1202 0.0000 1205 0.05428
i 11 1.56632 1.56632 .56519 .56519 0.12760 774.63 0.384 -0.01 0.013 7.2144 0.0000 0.5000 1033 0.767 5.4019 0.0000 1202 0.0000 1205 0.05428
i 11 1.56632 1.56632 .56519 .56519 0.12760 760.74 0.384 -0.01 0.013 7.2144 0.0000 0.5000 1033 0.767 5.4019 0.0000 1202 0.0000 1205 0.05428
i 11 1.56632 1.56632 1.06837 1.06837 0.10308 766.73 0.384 -0.01 0.013 7.2144 0.0000 0.5000 1033 0.767 5.4019 0.0000 1202 0.0000 1205 0.05428
i 11 2 2 .55567 .55567 0.00013 2512.3 0.721 0.042 0.018 5.3389 0.0000 0.5000 1030 0.921 5.0096 0.0000 1202 0.0000 1205 0.02774
i 11 2 2 1.11134 1.11134 0.00013 2593.0 0.721 0.042 0.018 5.3389 0.0000 0.5000 1030 0.921 5.0096 0.0000 1202 0.0000 1205 0.02774
i 11 2 2 1.11134 1.11134 0.00013 2521.3 0.721 0.042 0.018 5.3389 0.0000 0.5000 1030 0.921 5.0096 0.0000 1202 0.0000 1205 0.02774
i 11 2 2 1.11134 1.11134 0.00013 2586.1 0.721 0.042 0.018 5.3389 0.0000 0.5000 1030 0.921 5.0096 0.0000 1202 0.0000 1205 0.02774
i 11 2 2 1.11134 1.11134 0.00013 2564.1 0.721 0.042 0.018 5.3389 0.0000 0.5000 1030 0.921 5.0096 0.0000 1202 0.0000 1205 0.02774
i 11 2.01886 2.01886 .78696 .78696 0.12242 1571.5 0.462 0.015 0.007 7.9434 0.0000 0.5000 1029 0.928 7.0252 0.0000 1202 0.0000 1205 0.03948
i 11 2.01886 2.01886 .8675 .8675 0.03238 1580.5 0.462 0.015 0.007 7.9434 0.0000 0.5000 1029 0.928 7.0252 0.0000 1202 0.0000 1205 0.03948
i 11 2.01886 2.01886 .8675 .8675 0.03238 1611.0 0.462 0.015 0.007 7.9434 0.0000 0.5000 1029 0.928 7.0252 0.0000 1202 0.0000 1205 0.03948
i 11 2.01886 2.01886 .8675 .8675 0.03238 1615.1 0.462 0.015 0.007 7.9434 0.0000 0.5000 1029 0.928 7.0252 0.0000 1202 0.0000 1205 0.03948
i 11 2.0375 2.0375 .68461 .68461 0.05763 396.55 0.522 0.014 0.006 4.1040 0.0000 0.5000 1033 0.641 7.3385 0.0000 1202 0.0000 1205 0.03968
i 11 2.0375 2.0375 .68461 .68461 0.05763 402.72 0.522 0.014 0.006 4.1040 0.0000 0.5000 1033 0.641 7.3385 0.0000 1202 0.0000 1205 0.03968
i 11 2.0375 2.0375 .68461 .68461 0.05763 387.97 0.522 0.014 0.006 4.1040 0.0000 0.5000 1033 0.641 7.3385 0.0000 1202 0.0000 1205 0.03968
i 11 2.0375 2.0375 .68461 .68461 0.05763 387.92 0.522 0.014 0.006 4.1040 0.0000 0.5000 1033 0.641 7.3385 0.0000 1202 0.0000 1205 0.03968
i 11 2.0375 2.0375 .79183 .79183 0.05763 395.56 0.522 0.014 0.006 4.1040 0.0000 0.5000 1033 0.641 7.3385 0.0000 1202 0.0000 1205 0.03968
i 11 2.04056 2.04056 .6372 .6372 0.07878 2252.8 0.331 0.057 0.016 5.1787 0.0000 0.5000 1027 0.722 4.8610 0.0000 1202 0.0000 1205 0.04524
i 11 2.04056 2.04056 .6372 .6372 0.07878 2245.5 0.331 0.057 0.016 5.1787 0.0000 0.5000 1027 0.722 4.8610 0.0000 1202 0.0000 1205 0.04524
i 11 2.04056 2.04056 .6372 .6372 0.07878 2289.7 0.331 0.057 0.016 5.1787 0.0000 0.5000 1027 0.722 4.8610 0.0000 1202 0.0000 1205 0.04524
i 11 2.04056 2.04056 .89258 .89258 0.09658 2277.1 0.331 0.057 0.016 5.1787 0.0000 0.5000 1027 0.722 4.8610 0.0000 1202 0.0000 1205 0.04524
i 11 2.04203 2.04203 .64736 .64736 0.09230 1850.5 0.288 -0.01 0.020 4.2338 0.0000 0.5000 1029 0.787 7.1613 0.0000 1202 0.0000 1205 0.04119
i 11 2.04203 2.04203 .64736 .64736 0.09230 1798.7 0.288 -0.01 0.020 4.2338 0.0000 0.5000 1029 0.787 7.1613 0.0000 1202 0.0000 1205 0.04119
i 11 2.04203 2.04203 .64736 .64736 0.09230 1830.5 0.288 -0.01 0.020 4.2338 0.0000 0.5000 1029 0.787 7.1613 0.0000 1202 0.0000 1205 0.04119
i 11 2.04203 2.04203 .64736 .64736 0.09230 1830.0 0.288 -0.01 0.020 4.2338 0.0000 0.5000 1029 0.787 7.1613 0.0000 1202 0.0000 1205 0.04119
i 11 2.04203 2.04203 .82552 .82552 0.03545 1806.7 0.288 -0.01 0.020 4.2338 0.0000 0.5000 1029 0.787 7.1613 0.0000 1202 0.0000 1205 0.04119
i 11 2.05297 2.05297 .56269 .56269 0.12710 878.01 0.283 0.042 0.010 6.5392 0.0000 0.5000 1031 0.815 6.8996 0.0000 1202 0.0000 1205 0.04647
i 11 2.05297 2.05297 .56269 .56269 0.12710 863.67 0.283 0.042 0.010 6.5392 0.0000 0.5000 1031 0.815 6.8996 0.0000 1202 0.0000 1205 0.04647
i 11 2.05297 2.05297 .56269 .56269 0.12710 853.75 0.283 0.042 0.010 6.5392 0.0000 0.5000 1031 0.815 6.8996 0.0000 1202 0.0000 1205 0.04647
i 11 2.05297 2.05297 .92518 .92518 0.10959 865.95 0.283 0.042 0.010 6.5392 0.0000 0.5000 1031 0.815 6.8996 0.0000 1202 0.0000 1205 0.04647
i 11 2.05336 2.05336 .46109 .46109 0.05968 1097.7 0.290 0.043 0.014 7.3957 0.0000 0.5000 1034 0.726 4.9664 0.0000 1202 0.0000 1205 0.05284
i 11 2.05336 2.05336 .46109 .46109 0.05968 1110.7 0.290 0.043 0.014 7.3957 0.0000 0.5000 1034 0.726 4.9664 0.0000 1202 0.0000 1205 0.05284
i 11 2.05336 2.05336 .46109 .46109 0.05968 1115.1 0.290 0.043 0.014 7.3957 0.0000 0.5000 1034 0.726 4.9664 0.0000 1202 0.0000 1205 0.05284
i 11 2.05336 2.05336 1.05798 1.05798 0.08411 1101.2 0.290 0.043 0.014 7.3957 0.0000 0.5000 1034 0.726 4.9664 0.0000 1202 0.0000 1205 0.05284
i 11 2.5 2.5 .5408 .5408 0.00014 2560.8 0.395 0.023 0.019 6.9340 0.0000 0.5000 1027 0.951 7.4503 0.0000 1202 0.0000 1205 0.02681
i 11 2.5 2.5 1.08161 1.08161 0.00014 2516.7 0.395 0.023 0.019 6.9340 0.0000 0.5000 1027 0.951 7.4503 0.0000 1202 0.0000 1205 0.02681
i 11 2.5 2.5 1.08161 1.08161 0.00014 2621.4 0.395 0.023 0.019 6.9340 0.0000 0.5000 1027 0.951 7.4503 0.0000 1202 0.0000 1205 0.02681
i 11 2.5 2.5 1.08161 1.08161 0.00014 2491.9 0.395 0.023 0.019 6.9340 0.0000 0.5000 1027 0.951 7.4503 0.0000 1202 0.0000 1205 0.02681
i 11 2.5 2.5 1.08161 1.08161 0.00014 2597.5 0.395 0.023 0.019 6.9340 0.0000 0.5000 1027 0.951 7.4503 0.0000 1202 0.0000 1205 0.02681
i 11 2.52881 2.52881 .69992 .69992 0.05711 1620.0 0.817 0.039 0.006 6.1127 0.0000 0.5000 1031 0.904 6.3801 0.0000 1202 0.0000 1205 0.03433
i 11 2.52881 2.52881 .83876 .83876 0.03383 1649.8 0.817 0.039 0.006 6.1127 0.0000 0.5000 1031 0.904 6.3801 0.0000 1202 0.0000 1205 0.03433
i 11 2.52881 2.52881 .83876 .83876 0.03383 1628.2 0.817 0.039 0.006 6.1127 0.0000 0.5000 1031 0.904 6.3801 0.0000 1202 0.0000 1205 0.03433
i 11 2.52881 2.52881 .83876 .83876 0.03383 1661.9 0.817 0.039 0.006 6.1127 0.0000 0.5000 1031 0.904 6.3801 0.0000 1202 0.0000 1205 0.03433
i 11 2.53345 2.53345 .434 .434 0.06236 1146.3 0.865 0.062 0.010 9.2208 0.0000 0.5000 1032 0.853 6.8925 0.0000 1202 0.0000 1205 0.04739
i 11 2.53345 2.53345 .434 .434 0.06236 1155.0 0.865 0.062 0.010 9.2208 0.0000 0.5000 1032 0.853 6.8925 0.0000 1202 0.0000 1205 0.04739
i 11 2.53345 2.53345 .434 .434 0.06236 1149.0 0.865 0.062 0.010 9.2208 0.0000 0.5000 1032 0.853 6.8925 0.0000 1202 0.0000 1205 0.04739
i 11 2.53345 2.53345 .95898 .95898 0.05583 1149.6 0.865 0.062 0.010 9.2208 0.0000 0.5000 1032 0.853 6.8925 0.0000 1202 0.0000 1205 0.04739
i 11 2.53476 2.53476 .60939 .60939 0.08232 2333.4 0.437 -0.01 0.008 7.9211 0.0000 0.5000 1028 0.810 4.4729 0.0000 1202 0.0000 1205 0.04185
i 11 2.53476 2.53476 .60939 .60939 0.08232 2367.0 0.437 -0.01 0.008 7.9211 0.0000 0.5000 1028 0.810 4.4729 0.0000 1202 0.0000 1205 0.04185
i 11 2.53476 2.53476 .60939 .60939 0.08232 2348.6 0.437 -0.01 0.008 7.9211 0.0000 0.5000 1028 0.810 4.4729 0.0000 1202 0.0000 1205 0.04185
i 11 2.53476 2.53476 .84304 .84304 0.06295 2325.6 0.437 -0.01 0.008 7.9211 0.0000 0.5000 1028 0.810 4.4729 0.0000 1202 0.0000 1205 0.04185
i 11 2.5375 2.5375 .65661 .65661 0.06021 442.22 0.754 0.061 0.019 5.0117 0.0000 0.5000 1028 0.840 7.2079 0.0000 1202 0.0000 1205 0.03839
i 11 2.5375 2.5375 .65661 .65661 0.06021 446.48 0.754 0.061 0.019 5.0117 0.0000 0.5000 1028 0.840 7.2079 0.0000 1202 0.0000 1205 0.03839
i 11 2.5375 2.5375 .65661 .65661 0.06021 445.90 0.754 0.061 0.019 5.0117 0.0000 0.5000 1028 0.840 7.2079 0.0000 1202 0.0000 1205 0.03839
i 11 2.5375 2.5375 .65661 .65661 0.06021 436.96 0.754 0.061 0.019 5.0117 0.0000 0.5000 1028 0.840 7.2079 0.0000 1202 0.0000 1205 0.03839
i 11 2.5375 2.5375 .77065 .77065 0.06021 444.00 0.754 0.061 0.019 5.0117 0.0000 0.5000 1028 0.840 7.2079 0.0000 1202 0.0000 1205 0.03839
i 11 2.54867 2.54867 .61951 .61951 0.09644 1821.0 0.144 0.083 0.012 6.5295 0.0000 0.5000 1028 0.751 5.7451 0.0000 1202 0.0000 1205 0.04172
i 11 2.54867 2.54867 .61951 .61951 0.09644 1860.8 0.144 0.083 0.012 6.5295 0.0000 0.5000 1028 0.751 5.7451 0.0000 1202 0.0000 1205 0.04172
i 11 2.54867 2.54867 .61951 .61951 0.09644 1882.3 0.144 0.083 0.012 6.5295 0.0000 0.5000 1028 0.751 5.7451 0.0000 1202 0.0000 1205 0.04172
i 11 2.54867 2.54867 .61951 .61951 0.09644 1857.6 0.144 0.083 0.012 6.5295 0.0000 0.5000 1028 0.751 5.7451 0.0000 1202 0.0000 1205 0.04172
i 11 2.54867 2.54867 .83277 .83277 0.09300 1855.2 0.144 0.083 0.012 6.5295 0.0000 0.5000 1028 0.751 5.7451 0.0000 1202 0.0000 1205 0.04172
i 11 2.56325 2.56325 .53519 .53519 0.13280 909.18 0.303 -0.03 0.010 3.5100 0.0000 0.5000 1030 0.910 4.7971 0.0000 1202 0.0000 1205 0.04257
i 11 2.56325 2.56325 .53519 .53519 0.13280 905.46 0.303 -0.03 0.010 3.5100 0.0000 0.5000 1030 0.910 4.7971 0.0000 1202 0.0000 1205 0.04257
i 11 2.56325 2.56325 .53519 .53519 0.13280 901.10 0.303 -0.03 0.010 3.5100 0.0000 0.5000 1030 0.910 4.7971 0.0000 1202 0.0000 1205 0.04257
i 11 2.56325 2.56325 .85174 .85174 0.10967 914.39 0.303 -0.03 0.010 3.5100 0.0000 0.5000 1030 0.910 4.7971 0.0000 1202 0.0000 1205 0.04257
i 11 3 3 .52594 .52594 0.00014 2644.8 0.921 0.024 0.004 6.3790 0.0000 0.5000 1025 0.706 6.2906 0.0000 1202 0.0000 1205 0.02606
i 11 3 3 1.05188 1.05188 0.00014 2674.5 0.921 0.024 0.004 6.3790 0.0000 0.5000 1025 0.706 6.2906 0.0000 1202 0.0000 1205 0.02606
i 11 3 3 1.05188 1.05188 0.00014 2606.3 0.921 0.024 0.004 6.3790 0.0000 0.5000 1025 0.706 6.2906 0.0000 1202 0.0000 1205 0.02606
i 11 3 3 1.05188 1.05188 0.00014 2630.4 0.921 0.024 0.004 6.3790 0.0000 0.5000 1025 0.706 6.2906 0.0000 1202 0.0000 1205 0.02606
i 11 3 3 1.05188 1.05188 0.00014 2691.8 0.921 0.024 0.004 6.3790 0.0000 0.5000 1025 0.706 6.2906 0.0000 1202 0.0000 1205 0.02606
i 11 3.02136 3.02136 .66534 .66534 0.05511 1704.0 0.566 0.083 0.007 6.7348 0.0000 0.5000 1033 0.927 6.3347 0.0000 1202 0.0000 1205 0.03359
i 11 3.02136 3.02136 .82648 .82648 0.03298 1670.2 0.566 0.083 0.007 6.7348 0.0000 0.5000 1033 0.927 6.3347 0.0000 1202 0.0000 1205 0.03359
i 11 3.02136 3.02136 .82648 .82648 0.03298 1692.9 0.566 0.083 0.007 6.7348 0.0000 0.5000 1033 0.927 6.3347 0.0000 1202 0.0000 1205 0.03359
i 11 3.02136 3.02136 .82648 .82648 0.03298 1658.0 0.566 0.083 0.007 6.7348 0.0000 0.5000 1033 0.927 6.3347 0.0000 1202 0.0000 1205 0.03359
i 11 3.0375 3.0375 .65742 .65742 0.05869 526.14 0.277 -0.01 0.016 9.3859 0.0000 0.5000 1034 0.764 7.6771 0.0000 1202 0.0000 1205 0.03735
i 11 3.0375 3.0375 .65742 .65742 0.05869 528.03 0.277 -0.01 0.016 9.3859 0.0000 0.5000 1034 0.764 7.6771 0.0000 1202 0.0000 1205 0.03735
i 11 3.0375 3.0375 .65742 .65742 0.05869 520.49 0.277 -0.01 0.016 9.3859 0.0000 0.5000 1034 0.764 7.6771 0.0000 1202 0.0000 1205 0.03735
i 11 3.0375 3.0375 .65742 .65742 0.05869 525.17 0.277 -0.01 0.016 9.3859 0.0000 0.5000 1034 0.764 7.6771 0.0000 1202 0.0000 1205 0.03735
i 11 3.0375 3.0375 .74946 .74946 0.05869 528.00 0.277 -0.01 0.016 9.3859 0.0000 0.5000 1034 0.764 7.6771 0.0000 1202 0.0000 1205 0.03735
i 11 3.0391 3.0391 .6136 .6136 0.08024 2370.2 0.813 0.088 0.003 4.3194 0.0000 0.5000 1030 0.943 4.6850 0.0000 1202 0.0000 1205 0.03983
i 11 3.0391 3.0391 .6136 .6136 0.08024 2447.6 0.813 0.088 0.003 4.3194 0.0000 0.5000 1030 0.943 4.6850 0.0000 1202 0.0000 1205 0.03983
i 11 3.0391 3.0391 .6136 .6136 0.08024 2362.8 0.813 0.088 0.003 4.3194 0.0000 0.5000 1030 0.943 4.6850 0.0000 1202 0.0000 1205 0.03983
i 11 3.0391 3.0391 .8139 .8139 0.08204 2409.6 0.813 0.088 0.003 4.3194 0.0000 0.5000 1030 0.943 4.6850 0.0000 1202 0.0000 1205 0.03983
i 11 3.0437 3.0437 .62299 .62299 0.09401 1929.6 0.116 0.053 0.006 7.2441 0.0000 0.5000 1028 0.760 4.9282 0.0000 1202 0.0000 1205 0.04135
i 11 3.0437 3.0437 .62299 .62299 0.09401 1973.2 0.116 0.053 0.006 7.2441 0.0000 0.5000 1028 0.760 4.9282 0.0000 1202 0.0000 1205 0.04135
i 11 3.0437 3.0437 .62299 .62299 0.09401 1984.1 0.116 0.053 0.006 7.2441 0.0000 0.5000 1028 0.760 4.9282 0.0000 1202 0.0000 1205 0.04135
i 11 3.0437 3.0437 .62299 .62299 0.09401 1933.0 0.116 0.053 0.006 7.2441 0.0000 0.5000 1028 0.760 4.9282 0.0000 1202 0.0000 1205 0.04135
i 11 3.0437 3.0437 .8167 .8167 0.06703 1939.2 0.116 0.053 0.006 7.2441 0.0000 0.5000 1028 0.760 4.9282 0.0000 1202 0.0000 1205 0.04135
i 11 3.04835 3.04835 .45081 .45081 0.06078 1000.9 0.038 0.100 0.008 4.3858 0.0000 0.5000 1032 0.706 5.2188 0.0000 1202 0.0000 1205 0.04488
i 11 3.04835 3.04835 .45081 .45081 0.06078 1004.1 0.038 0.100 0.008 4.3858 0.0000 0.5000 1032 0.706 5.2188 0.0000 1202 0.0000 1205 0.04488
i 11 3.04835 3.04835 .45081 .45081 0.06078 989.70 0.038 0.100 0.008 4.3858 0.0000 0.5000 1032 0.706 5.2188 0.0000 1202 0.0000 1205 0.04488
i 11 3.04835 3.04835 .91216 .91216 0.12531 998.40 0.038 0.100 0.008 4.3858 0.0000 0.5000 1032 0.706 5.2188 0.0000 1202 0.0000 1205 0.04488
i 11 3.06134 3.06134 .54472 .54472 0.12944 978.92 0.554 0.067 0.013 4.7781 0.0000 0.5000 1031 0.730 7.4948 0.0000 1202 0.0000 1205 0.04283
i 11 3.06134 3.06134 .54472 .54472 0.12944 987.38 0.554 0.067 0.013 4.7781 0.0000 0.5000 1031 0.730 7.4948 0.0000 1202 0.0000 1205 0.04283
i 11 3.06134 3.06134 .54472 .54472 0.12944 989.27 0.554 0.067 0.013 4.7781 0.0000 0.5000 1031 0.730 7.4948 0.0000 1202 0.0000 1205 0.04283
i 11 3.06134 3.06134 .85577 .85577 0.09002 998.40 0.554 0.067 0.013 4.7781 0.0000 0.5000 1031 0.730 7.4948 0.0000 1202 0.0000 1205 0.04283
f 0 6.8 6.8
e 
