
;				FILT 4		[   O R C H E S T R A   ]

;------------------------------------------------------------------------------
;	ENREGISTREMENT FILTRE PASSE-BANDE FORMANTS
;------------------------------------------------------------------------------

; enonces generaux . . .
	sr = 44100				; taux d'ech. audio : 44100
	kr = 2205				; taux d'ech. controle : 2205
	ksmps = 20				; = sr/kr 
	nchnls = 1				; "mono"

; instruments . . .
	instr 1									; Enregistrement original
		aorig	soundin	1
				out		aorig
	endin

	instr 4									; Enregistrement --> 3 passe-bande
		icf1	=		exp((p7/20.0)*log(10.0))
		icf2	=		exp((p11/20.0)*log(10.0))
		icf3	=		exp((p15/20.0)*log(10.0))
		aorig	soundin	1
		kfr1	expseg	p4,p3,p5
		kfr2	expseg	p8,p3,p9
		kfr3	expseg	p12,p3,p13
		afilt1	reson	aorig,kfr1,p6
		afilt2	reson	aorig,kfr2,p10
		afilt3	reson	aorig,kfr3,p14
		acorr	balance	(afilt1*icf1)+(afilt2*icf2)+(afilt3*icf3),aorig
				out		acorr*p16
	endin
