;***********************************************************************
;
;	Frequency modulation synthesis  instrument
;
;	p1	instrument number
;	p2	entry delay
;	p3	duration
;	p4	global amplitude (normalized {0,1})
;	p5	reference frequency (f0)
;	p6	stereo balance   ( 0 = left / 1 = right )
;	p7	carrier frequency factor
;	p8	modulation frequency factor
;	p9	minimum index
;	p10	maximum index
;	p11	Function for Index Envelope
;	p12	jitter amplitude ( {0,1} internal perceptual compensation )
;	p13	tremolo amplitude ({0,1}    "         "            "      )
;	p14	tremolo frequency ( in Hertz. )
;	p15	attack duration   ( in secs. )
;	p16	decay duration    ( in secs. internal readjustment if needed)
;	p17 	function for amp. envelope (micro)
;	p18	balance freq.jitter/vibrato (1 = jitter / 0 = vibrato)
;	p19	vibrato frequency ( in Hertz. )
;	p20	frequency deviation ( absolute value in semitones )
;	p21	fuction for freq. envelope
;	p22	portato amplitude   ( absolute value in semitones )
;	p23	function for portato
;	p24	duration of portato
;	p25	Modulation freq. affected by portamento ? (0 = no;1 = yes)
;
;	Compulsory Functions :
;	f1	audio sine wave
;	f2	vibrato
;	f3	tremolo
;************************************************************************

; Globals

;	sr     = 32000			These globals to
;	kr     = 4000			to be read
;	ksmps  = 8			on the file
;	nchnls = 2			header.orc

	giramp = 1.0 / 3.0	; Some constants for a good jitter
	girfq1 = 22.071		; from a model described in Chant
	girfq2 = 8.749
	girfq3 = 1.007

	gimxamp= 32767

	gibal  = 2.13		; Factor to balance rms of jit/vib(trem)
				; (See below)


instr 31

			; Initialization	
			; --------------


		idurosc   = 	1.0 / p3
		igbamp	  =	gimxamp * p4
		ifroct	  =     octcps( p5 )
		icar	  =	p7 * p5      ; actual carrier frequency
		imodl	  =	p8 * p5	     ;   "   modulation   "
		kfrqn2	init	p8
		indxd	  =	p10 - p9

; if att+dec > dur, reajust dec, but keep att the same
		idec	  =	( p15 + p16 <= p3 ? p16 : p3-p15 )
; if att >= dur, put, by default, att = dec = 1/2*dur (no undesirable clicks)
		iatt	  =	( idec >= 0 ? p15 : p3/2)
		idec	  =	( idec >= 0 ? idec : p3/2 )

; old version	idec	  =	( p15 + p16 <= p3 ? p16 : p3-p15 )

		ifdev	  =	p20 / 12	   ; octave representation
		ifprt1	  =	p22 / 12	   ; (1 = octave)
		ifprt2	  = 	ifprt1 * ( p8 / p7 )


						   ; corrections on 
						   ; jitter/tremolo (vibrato)
		if   p18 !=1    goto else1	   ; amplitude factors, to
		ifjit	  =	ifdev		   ; compensate perceptual
		ifvib	  =	0		   ; energy.
		goto 	cont1
else1:
		idivf	  =	p18 / (1 - p18)
		ifp18     =	idivf * gibal / (idivf * gibal + 1)
		ifjit	  = 	(ifp18 >= 1 ? ifdev : ifdev * ifp18)
		ifvib	  = 	ifdev * (1 - ifp18)
cont1:
		isuma	  =  	abs(p12) + abs(p13) ;amp nust be absoulte
		if   p12*p13 != 0  goto else2
		iajit	  =	p12 * gibal * igbamp
		iajit	  =	(abs(iajit) > gimxamp ? gimxamp : iajit)
		iatrm	  =	p13 * igbamp
		iatrm	  =	(abs(iatrm) > gimxamp ? gimxamp : iatrm)
		goto cont2
else2:
		isignp12  =	(p12 < 0.0 ? -1 : 1)
		isignp13  =	(p13 < 0.0 ? -1 : 1)
		idiva	  =     abs(p12) / abs(p13)
		iap12	  =	isuma * idiva * gibal / (idiva * gibal + 1)
		iap13	  =	isuma - iap12
		iajit	  = 	igbamp * iap12 * isignp12
		iajit	  =	(abs(iajit) > gimxamp ? gimxamp : iajit)
		iatrm	  =	igbamp * iap13 * isignp13
		iatrm	  =	(abs(iatrm) > gimxamp ? gimxamp : iatrm)
cont2:
	        imod      = 	 abs(iajit) + abs(iatrm)
        	if imod  <= 	igbamp goto cont3	; too much modulation
		imodscal  = 	igbamp/imod    	        ; reduce it keeping
		iajit	  = 	iajit * imodscal	; ratio jit/trem
		iatrm	  = 	iatrm * imodscal
cont3:
		iamprel   =	( igbamp-imod < 0.0 ? 0.0 : igbamp-imod )



				;--- Amplitude ---
				;    ---------


	; Jitter module

		kaj1	randi	giramp,girfq1,-1
		kaj2	randi	giramp,girfq2,-1
		kaj3	randi	giramp,girfq3,-1

		kajit     =	(kaj1 + kaj2 + kaj3) * iajit

	; Tremolo module

		katrm	oscili	iatrm,p14,3

	; Amplitude modulation

		kamod	  =	kajit + katrm + iamprel

	; Amplitude envelope

		kaenv   oscili 	kamod,idurosc,p17

	; Global amplitude envelope

		kamp 	linen 	kaenv,p15,p3,idec


   			   ;--- Carrier Frequency ---
			   ;    -----------------


	; Jitter module

		kfj1	randi	giramp,girfq1,-1
		kfj2	randi	giramp,girfq2,-1
		kfj3	randi	giramp,girfq3,-1

		kfjit     =	(kfj1 + kfj2 + kfj3) * ifjit

	; Vibrato module

		kfvib	oscili	ifvib,p19,2

	; Frequency "modulation"

		kfmod	  =	kfjit + kfvib

	; Frequency envelope

		kfenv1  oscili 	kfmod,idurosc,p21

	; Portato module

		kfprt1	oscil1i	0,ifprt1,p24,p23

	; Global frequency 
					; modulation affects total freq.
					; but foscili wants ratio only

		kfrqn1	  =	icar / (cpsoct ( ifroct - kfenv1 - kfprt1 ))


				; Modulation Frequency
				; ---------- ---------

		if  p25  =  0	goto nomod	; if flag=0 no portato
						; applied to mod. freq.

	; Portato module

		kfprt2	oscil1i	0,ifprt2,p24,p23

	; or 	kfprt2 	   = 	kfprt1 * (p8 / p7)

	; Frequency Envelope

;		kfenv2	oscili	kfprt2,idurosc,p21

	; Global Frequency

		kfrqn2	  =	imodl / (cpsoct( ifroct - kfprt2 ))

nomod:

			         ;--- Index ---
 			         ;    -----


	; Envelope Index

		kndxa	oscili  indxd,idurosc,p11

		kndx	  =	kndxa + p9


		        ;--- Main oscillator / panning ---
			;    ---------------   -------



		asig	foscili	kamp,p5,kfrqn1,kfrqn2,kndx,1
		al	  =	asig * (1 - p6)
		ar	  =	asig - al
		outs		al,ar

endin

