;			HARMONISEUR 	[   O R C H E S T R A   ]
;------------------------------------------------------------------------------
;	DOUBLE LECTURE, ENVELOPPEE, DANS UN TAMPON AJUSTABLE DE DUREE
;	MAXIMALE 0.125 sec.
;------------------------------------------------------------------------------

; enonces generaux . . .
	sr = 32000				; taux d'ech. audio : 32000
	kr = 32000				; taux d'ech. controle : 32000
	ksmps = 1				; = sr/kr 
	nchnls = 1				; "mono"

; instrument auxiliaire, pour ecoute du son pre-enregistre original
	instr 3
		a1	soundin	p4		; voix = fichier soundin.1
			out	a1
	endin

; instrument 4 :	a pour fonction de fournir les echantillons a moduler,
;			dans la variable "gatobe" : lira le fichier
;			"soundin.(p4)"
;		Configuration generale (PEU EFFICACE), pour fins pedagogiques
	instr 4
		gatobe	soundin p4			; lecture brute
	endin

; instrument 5 :	a pour fonction de fournir
;			(1)	les rapports de transposition dans la variable
;				"gktrnsp"
;			(2)	la grandeur de la fenetre, entre 0 et 1, dans
;				la variable "gkfen"
;		Configuration generale (PEU EFFICACE), pour fins pedagogiques
	instr 5
		gktrnsp	line p4,p3,p5
		gkfen	line p6,p3,p7
	endin

; instrument 6 :	HARMONISEUR (double lecture dans un tampon <= 0.125 sec)
;			- recoit les echantillons dans "gatobe", et utilise
;			  l'enveloppe "p4"
;			- recoit ses controles dans
;			  (1)	"gktrnsp", en rapports de transposition (ex.:
;				0.5 ==> octave grave ; 2 ==> octave aigue)
;			  (2)	"gkfen" dans [0,1] : un facteur de taille de
;				la fenetre de bouclage ==> granulation
;			- sort la modulation dans "garez"
;		Configuration generale (PEU EFFICACE), pour fins pedagogiques
; REMARQUES :
; (1)	cet instrument provoque normalement un certain delai entre son entree
;	et sa sortie ; on peut donc eventuellement allonger legerement sa
;	duree d'action, afin de ne pas ecourter la fin de l'entree
; (2)	la double lecture provoque un leger gain entre l'entree et la sortie
;	(de l'ordre de +3dB, ou environ 1.4)
;
	instr 6
		; initialisations
			imax	= 0.125		;tampon max. (sec.)
			kdresse	init 0.0	;adresse de lecture dans tampon
			abidon	delayr imax
		; CALCUL : les enonces conditionnels obligent les adresses
		; de lecture du son et des enveloppes a etre des variables de
		; controle (de type "k...")
		;adresse lecture principale dans tampon de duree klfen <= imax
			klfen	= imax*gkfen		;longueur reelle tampon
			kdresse	= kdresse+((-gktrnsp+1)/kr)	
			kdresse	= ((kdresse < 0.0  ) ? klfen+kdresse : kdresse)
			kdresse	= ((kdresse > klfen) ? kdresse-klfen : kdresse)
		;lecture son <1>
			abrut	deltapi kdresse
		;lecture enveloppe "p4" <1>, synchrone a la lecture du son
			kenvlp	= kdresse/klfen
			kamp	tablei kenvlp,p4, 1
		;application enveloppe <1>
			aenv1	= abrut*kamp
		;adresse de lecture secondaire (decalee d'un demi tampon)
			kdrss	= kdresse+(klfen/2.0)
			kdrss	= ((kdrss > klfen) ? kdrss-klfen : kdrss)
		;lecture son <2>
			abrut	deltapi kdrss
		;lecture enveloppe "p4" <2>
			kenvlp	= kdrss/klfen
			kamp	tablei kenvlp,p4, 1
		;application enveloppe <2>
			aenv2	= abrut*kamp
		;mixage <1> + <2>
			garez	= aenv1+aenv2
		;ecriture dans le tampon
				delayw gatobe
	endin

; instrument 7 :	recoit et sort le resultat "garez"
;		Configuration generale (PEU EFFICACE), pour fins pedagogiques
	instr 7
			out garez
	endin
