
;				SPAT 3		[   O R C H E S T R A   ]

;------------------------------------------------------------------------------
;	POSITIONNEMENT STATIQUE "ambisonique"
;   Cf. BENNET, Gerald, 1997 : "De quelques techniques de diffusion pour
;   compositeur pauvre", in <Composition/diffusion en musique
;   electroacoustique>, Bourges, Mnemosyne (Academie internationale de musique
;   electroacoustique) : 32-33. Avec modifications importantes.
;------------------------------------------------------------------------------

; enonces generaux . . .
	sr = 44100				; taux d'ech. audio : 44100
	kr = 441				; taux d'ech. controle : 441 (pas utilise ici)
	ksmps = 100				; = sr/kr 
	nchnls = 2				; "stereo"

; Ceci place un son en un point specifique d'un espace carre a deux dimensions.
; Les haut-parleurs jouent le role de deux "fenetres" ouvertes permettant
; d'entendre la source sonore situee dans cet espace. L'auditeur est positionne
; a egale distance des deux haut-parleurs.

;p4			numero de fichier son a spatialiser : soundin.<p4>
;p5			dimension d'un cote de l'espace carre, en metres
;p6			distance entre les deux haut-parleurs, en metres
;p7			distance de l'auditeur par rapport aux haut-parleurs
;p8,p9		[x,y] coordonnees de la position de la source sonore, entre 0 et 1
;			x = 0 => gauche
;			x = 1 => droite
;			y = 0 => proche
;			y = 1 => lointain ( p9 > 1.0 : possible )

givelair	=		340.0						;vitesse du son dans l'air (m/s)
gifactor	=		1.618						;nombre d'or ???

instr 3
  ;preparation des distances
	isize		=		p5
	ix			=		p8*isize				;conversion des coord. en metres
	iy			=		p9*isize
	ilspeaker	=		(isize-p6)/2			;pos. h.-p. g. sur axe x
	irspeaker	=		isize-ilspeaker			;pos. h.-p. d. sur axe x
  ;distances du point [p8,p9] par rapport a chaque h.-p. : theoreme de Pythagore
	idlsq		=		((ilspeaker-ix)*(ilspeaker-ix))+(iy*iy)
	idrsq		=		((irspeaker-ix)*(irspeaker-ix))+(iy*iy)
	idisl		=		sqrt(idlsq)				;distance au h.-p. g.
	idisr		=		sqrt(idrsq)				;distance au h.-p. d.
  ;calcul des temps de parcours du signal vers chaque h.-p., selon distances
	idelayl		=		idisl/givelair
	idelayr		=		idisr/givelair
  ;coefficient de correction d'amplitude, selon distances : l'energie varie
  ;comme l'inverse du carre de l'accroissement de la distance :
  ;par ex. (1.0/(((p7+idisl)/p7)^2.0))
	iterml		=		1.0/(exp(2.0*(log((p7+idisl)/p7))))
	itermr		=		1.0/(exp(2.0*(log((p7+idisr)/p7))))
  ;frequences de coupure des filtres, selon distances, plafonnees a 50 kHz, pour
  ;eviter exces inutiles et problemes de distorsion quand une distance < 8 cm.
	ifilterl	=		50000.0/(gifactor*(idisl < 0.618 ? 0.618 : idisl))
	ifilterr	=		50000.0/(gifactor*(idisr < 0.618 ? 0.618 : idisr))
  ;faire entrer un son mono, etc...
	aleson	soundin	p4							;cobaye <-- soundin.<p4>
	aleft	delay	aleson,idelayl				;delai signal -> h.-p. g.
	aright	delay	aleson,idelayr				;delai signal -> h.-p. d.
	aleft	=		aleft*iterml				;correct. ampl. selon distances
	aright	=		aright*itermr
	aleft	tone	aleft,ifilterl				;pertes de freqs aigues par...
	aleft	tone	aleft,ifilterl				;...
	aright	tone	aright,ifilterr				;... absorption dans l'air...
	aright	tone	aright,ifilterr				;...
			outs1	aleft
			outs2	aright
endin
