
;				SPAT 4		[   O R C H E S T R A   ]

;------------------------------------------------------------------------------
;	POSITIONNEMENT DYNAMIQUE "ambisonique"
;   Cf. BENNET, Gerald, 1997 : "De quelques techniques de diffusion pour
;   compositeur pauvre", in <Composition/diffusion en musique
;   electroacoustique>, Bourges, Mnemosyne (Academie internationale de musique
;   electroacoustique) : 32-33. Avec modifications importantes.
;------------------------------------------------------------------------------

; enonces generaux . . .
	sr = 44100				; taux d'ech. audio : 44100
	kr = 22050				; taux d'ech. controle : 22050
	ksmps = 2				; = sr/kr 
	nchnls = 2				; "stereo"

; Ceci deplace un son dans un espace carre a deux dimensions, a partir d'une
; position de depart vers une position d'arrivee.
; Les haut-parleurs jouent le role de deux "fenetres" ouvertes permettant
; d'entendre la source sonore se deplacant dans cet espace. L'auditeur est
; place a egale distance des deux haut-parleurs.

;p4			numero de fichier son a spatialiser : soundin.<p4>
;p5			dimension d'un cote de l'espace carre, en metres
;p6			distance entre les deux haut-parleurs, en metres
;p7			distance de l'auditeur par rapport aux haut-parleurs
;p8,p9		[x1,y1] coord. de la pos. de depart de la source, entre 0 et 1
;p10,p11	[x2,y2] coord. de la pos. d'arrivee de la source, entre 0 et 1
;			x = 0 => gauche
;			x = 1 => droite
;			y = 0 => proche
;			y = 1 => lointain ( y > 1.0 : possible )

givelair	=		340.0						;vitesse du son dans l'air (m/s)
gifactor	=		1.618						;nombre d'or ???

instr 3
	isize		=		p5
	ixstart		=		p8*isize				;conversion des coord. en metres
	ixend		=		p10*isize
	iystart		=		p9*isize
	iyend		=		p11*isize
	ilspeaker	=		(isize-p6)/2			;pos. h.-p. g. sur axe x
	irspeaker	=		isize-ilspeaker			;pos. h.-p. d. sur axe x
  ;[ixstart,iystart] --> [ixend,iyend] : position variable pendant la duree
	kx			line	ixstart,p3,ixend		;[kx,ky] = pos. instantanee
	ky			line	iystart,p3,iyend
  ;distances variables du point [kx,ky] par rapport a ch. h.-p. : th. Pythagore
	kdlsq		=		((ilspeaker-kx)*(ilspeaker-kx))+(ky*ky)
	kdrsq		=		((irspeaker-kx)*(irspeaker-kx))+(ky*ky)
	kdisl		=		sqrt(kdlsq)
	kdisr		=		sqrt(kdrsq)
  ;calcul des temps de parcours du signal vers ch. h.-p., selon dist. variables
	kdelayl		=		kdisl/givelair
	kdelayr		=		kdisr/givelair
  ;coefficients de correction d'amplitude selon distances variables : l'energie
  ;varie comme l'inverse du carre de l'accroissement de la distance :
  ;par ex. (1.0/(((p7+kdisl)/p7)^2.0))
	kterml		=		1.0/(exp(2.0*(log((p7+kdisl)/p7))))
	ktermr		=		1.0/(exp(2.0*(log((p7+kdisr)/p7))))
  ;frequences de coupure des filtres, selon distances variables, plafonnees
  ;a 50 kHz, pour eviter exces inutiles et problemes de distorsion quand une
  ;distance < 8 cm.
	kfilterl	=		50000.0/(gifactor*(kdisl < 0.618 ? 0.618 : kdisl))
	kfilterr	=		50000.0/(gifactor*(kdisr < 0.618 ? 0.618 : kdisr))
  ;faire entrer un son mono, etc...
	aleson	soundin	p4							;cobaye <-- soundin.<p4>
	abidon	delayr	1
		aleft	deltapi	kdelayl					;delai var. signal -> h.-p. g.
		aright	deltapi	kdelayr					;delai var. signal -> h.-p. d.
				delayw	aleson
	aleft	=		aleft*kterml				;correct ampl. selon dist. var.
	aright	=		aright*ktermr
	aleft	tone	aleft,kfilterl				;pertes de freqs aigues par...
	aleft	tone	aleft,kfilterl				;...
	aright	tone	aright,kfilterr				;... absorption dans l'air...
	aright	tone	aright,kfilterr				;...
			outs1	aleft
			outs2	aright
endin
