
;				SPAT 5		[   O R C H E S T R A   ]

;------------------------------------------------------------------------------
;	POSITIONNEMENT DYNAMIQUE SIMPLIFIE, sans Pythagore, ni delais, ni filtres
;------------------------------------------------------------------------------

; enonces generaux . . .
	sr = 44100				; taux d'ech. audio : 44100
	kr = 22050				; taux d'ech. controle : 22050
	ksmps = 2				; = sr/kr 
	nchnls = 2				; "stereo"

; Permet de deplacer un son d'une position de depart a une position d'arrivee
; dans un espace a deux dimensions.

;p4			numero fichier son soundin.<p4>
;p5,p6		[x1,y1] coordonnees de la position de depart ( 0<=x<=90 ; y>=1.0 )
;p7,p8		[x2,y2] coordonnees de la position d'arrivee ( 0<=x<=90 ; y>=1.0 )
;			x =  0 => gauche
;			x = 90 => droite
;			y = 1.0 => proche
;			y > 1.0 => allant vers le lointain...

instr 3
  ;[kangle,kdista] = position variable
	kangle	line	p5,p3,p7				;<p5> -> <p7> pendant la duree
	kdista	line	p6,p3,p8				;<p6> -> <p8> pendant la duree
  ;coefficient d'attenuation selon distance : eviter kdista < 1.0 => kampli>1.0
	kampli	=		exp(1.3*log(kdista))	;(kdista^1.3) empiriquement
	kampli	=		1.0/(kampli < 1.0 ? 1.0 : kampli)
  ;coefficients de positionnement gauche/droite
	kgauche	tablei	((kangle+90.0)/180.0),2,1	;sin[90,180] = cos[0,90] -> g.
	kdroite	tablei	( kangle      /180.0),2,1	;sin[ 0, 90]             -> d.
  ;faire entrer un son mono...
	aleson	soundin	p4							;cobaye <-- soundin.<p4>
	aleson	=		aleson*kampli
			outs1	aleson*kgauche
			outs2	aleson*kdroite
endin
