;;;*****************************************************************************
;;; Ttraphonie statique degrs CSound
;;;*****************************************************************************
;;
;;   0:=A           B:=90
;;
;;
;;
;;
;; 270:=C           D:=180
;;
;; Pour placer 0 au milieu entre h.-p. A et B ( "12:00") : ajouter 45 dans
;; chaque expression ci-dessous - cf. expressions en commentaires  droite.

;; Variable globale.
	girad		=		2.0*3.14159/360.0

;; Dans instrument : calcul des coefficients bruts d'amplitude pour les quatre
;; h.-p., o <ideg> est la position dsire dans [0,360].
	iaa			=		cos(girad*ideg)					;cos(girad*(ideg+45))
	iab			=		sin(girad*ideg)					;sin(girad*(ideg+45))
	iac			=		sin(girad*(ideg-90))			;sin(girad*(ideg-45))
	iad			=		sin(girad*(ideg-180))			;sin(girad*(ideg-135))

;; Au moment d'utiliser les coefficients aux sorties, annuler les valeurs
;; ngatives avec des noncs conditionnels.
				outq1	audio*(iaa < 0.0 ? 0.0 : iaa)
				outq2	audio*(iab < 0.0 ? 0.0 : iab)
				outq3	audio*(iac < 0.0 ? 0.0 : iac)
				outq4	audio*(iad < 0.0 ? 0.0 : iad)

;;;*****************************************************************************
;;; Ttraphonie mobile degrs CSound
;;;*****************************************************************************
;;
;;   0:=A           B:=90
;;
;;
;;
;;
;; 270:=C           D:=180
;;
;; Pour placer 0 au milieu entre h.-p. A et B ( "12:00") : ajouter 1/8=0.125
;; dans chaque expression ci-dessous - cf. expressions en commentaires  droite.

;; Dans fichier score : une table <n> contenant une sinusode.
	f <n> 0 4097 10 1									;sinusode

;; Dans instrument : consultation de la sinusode par des objets tablei aux
;; adresses suivantes, rendant les coefficients bruts d'amplitude pour les
;; quatre h.-p., o <kdeg> est la position dsire dans [0,360].
;; Les tablei doivent tre en modes d'adressage "normalized" et "wraparound".
	kdegaun		=		kdeg/360.0
	kaa			tablei	kdegaun+0.25,<n>,1,0,1			;kdegaun+0.375
	kab			tablei	kdegaun,     <n>,1,0,1			;kdegaun+0.125
	kac			tablei	kdegaun-0.25,<n>,1,0,1			;kdegaun-0.125
	kad			tablei	kdegaun-0.5, <n>,1,0,1			;kdegaun-0.375

;; Au moment d'utiliser les coefficients aux sorties, annuler les valeurs
;; ngatives avec des noncs conditionnels.
				outq1	audio*(kaa < 0.0 ? 0.0 : kaa)
				outq2	audio*(kab < 0.0 ? 0.0 : kab)
				outq3	audio*(kac < 0.0 ? 0.0 : kac)
				outq4	audio*(kad < 0.0 ? 0.0 : kad)

;;;*****************************************************************************
;;; Ttraphonie statique cartsienne CSound
;;;*****************************************************************************
;;         y
;;
;;         |
;; [0;1]:=A|          B:=[1;1]
;;         |
;;         |
;;         |
;;         |
;; [0;0]:=D|__________C:=[0;1]__ x

;; Variable globale.
	gip2		=		3.14159/2.0

;; Dans instrument : calcul des coefficients bruts d'amplitude ensuite combins
;; pour les amplitudes des quatre h.-p., o [<ix>,<iy>] est la position
;; dsire.
	ic1			=		cos(gip2*ix)
	ic2			=		sin(gip2*iy)
	ic3			=		sin(gip2*ix)
	ic4			=		cos(gip2*iy)

;; Utiliser les coefficients aux sorties.
				outq1	audio*ic1*ic2
				outq2	audio*ic3*ic2
				outq3	audio*ic3*ic4
				outq4	audio*ic1*ic4

;;;*****************************************************************************
;;; Ttraphonie mobile cartsienne CSound
;;;*****************************************************************************
;;         y
;;
;;         |
;; [0;1]:=A|          B:=[1;1]
;;         |
;;         |
;;         |
;;         |
;; [0;0]:=D|__________C:=[0;1]__ x

;; Dans fichier score : une table <n> contenant une premire moiti de sinusode.
	f <n> 0 4097 9 0.5 1 0								;demi-sinusode

;; Dans instrument : consultation de la demi-sinusode par des objets tablei
;; aux adresses suivantes, rendant les coefficients bruts d'amplitude ensuite
;; combins pour les amplitudes des quatre h.-p., o [<kx>,<ky>] est la position
;; dsire.
;; Les tablei doivent tre en modes d'adressage "normalized" et "wraparound".
	kc1			tablei	0.5*(kx+1.0),<n>,1,0,1
	kc2			tablei	ky/2.0,      <n>,1,0,1
	kc3			tablei	kx/2.0,      <n>,1,0,1
	kc4			tablei	0.5*(ky+1.0),<n>,1,0,1

;; Utiliser les coefficients aux sorties.
				outq1	audio*kc1*kc2
				outq2	audio*kc3*kc2
				outq3	audio*kc3*kc4
				outq4	audio*kc1*kc4
