<CsoundSynthesizer>
<CsInstruments>

;				DIDA 5		[   O R C H E S T R A   ]

;------------------------------------------------------------------------------
;	ADJONCTION D'UN VIBRATO
;------------------------------------------------------------------------------

; enonces generaux . . .
	sr = 44100				; taux d'ech. audio : 44100
	kr = 2205				; taux d'ech. controle : 2205
	ksmps = 20				; = sr/kr 
	nchnls = 1				; "mono"

; instrument . . .
	instr 8
		kenv		envlpx	ampdb(90+p4),p6,p3,p7, 2, 2.0,0.01
		iambit	=		p8-p5
		kgliss	oscil1i	0,iambit,p3, 3
		kmodu		oscili	p9,p10, 4
		ason		oscili	kenv,(kgliss+kmodu+p5), 1
				out		ason

	endin
</CsInstruments>
<CsScore>

;				DIDA 5		[   S C O R E   ]

;------------------------------------------------------------------------------
;	ADJONCTION D'UN VIBRATO
;------------------------------------------------------------------------------

; fonctions . . .
	f 1 0 4096 9	1	0.75	0	; gen9 --> f1 :
				2	0.5	180	; spectre harmonique
				3	0.25	0	; (son de base)
				4	0.25	35.0
				5	0.65	0
				6	0.06	0

	f 2 0 1025 5	0.001	300		; gen5 --> f2 :
				1	100		; segments exponentiels
				1	624		; (attaque enveloppe globale)
				0.15

	f 3 0 1025 7	0	512		; gen7 --> f3 :
				0.9	100		; segments droits
				0.95	200		; (profil glissando)
				1.0	212
				1.0

	f 4 0 1024 10	1			; gen10 --> f4 : sinusoide
							; (vibrato)

; "note" . . .
	i	8			; p1 : no d'instrument
		0			; p2 : date
		7			; p3 : duree
			-10		; p4 : amplitude globale (dB<0)
			170		; p5 : freq. fond. a l'attaque (Hz)
			0.04		; p6 : duree attaque env. globale (sec)
			3.8		; p7 : duree chute env. globale (sec)
			294		; p8 : freq. terminale du glissando (Hz)
			2.9		; p9 : profondeur de vibrato (Hz)
			7.3		; p10 : vitesse de vibrato

	e				; END
</CsScore>

</CsoundSynthesizer>
<MacOptions>
Version: 3
Render: File
Ask: Yes
Functions: Window
WindowBounds: 34 55 775 839
Options: -b128 -A -o/Volumes/DD/1DLO/csound.d/dida.d/dida4.aif -s -m7 -R 
</MacOptions>
<MacGUI>
ioView background {60108, 65535, 63132}
ioListing {75, 280} {562, 166}
ioSlider {76, 39} {34, 229} 20.000000 2000.000000 1699.832031 pitch
</MacGUI>
