;!
;! Version Macintosh LispWorks 2009, adapte de la version MCL 15/07/2001 ==>
;! suppression de tout l'inutile par rapport aux versions antrieures (UNIX et
;! MCL).

;;; ENVIRONNEMENT --------------------------------------------------------------
;$$ UMGEBUNG ---------------------------------------------------------[d..H.B.]
;++ ENVIRONMENT ----------------------------------------------------------------

(setq *print-length* nil)
(setq *print-level* nil)

;;   Afin de pouvoir dplacer librement le directory cl.d sans avoir  diter
;; de paths dans le prsent fichier d'initialisation... (en cas de dmnagement,
;; installation sur autre disque ou ordinateur, etc.).
;$   Um freies Verschieben dieses Ordner zu ermglichen, ohne die Pfade in
;$ dieser Initialisierungsdatei von Hand anpassen zu mssen (beim Verschieben
;$ in einen anderen Ordner, auf ein anderes Laufwerk, Rechner, usw.). 
;+   To allow free displacement of the present directory, without hand editing
;+ of paths in the present file... (in case of move to another folder, volume or
;+ computer).
(defvar common-lisp::*pathcldlo*
   (make-pathname :directory
          (pathname-directory *load-truename*)))      ; <--- PATH d'installation

;; Path divers utiles...
;$ Verschiedene ntzliche Pfade...
;+ Various useful paths...
(defvar common-lisp::*path-ped*
  (merge-pathnames "ped.d/" common-lisp::*pathcldlo*))

;; Gestion du module "canons-stochastiques"
;$ Verwaltung des "canons-stochastiques"-Moduls
;+ Management of the "canons-stochastiques" module
(defvar common-lisp::*path-stochastique*
  (merge-pathnames "stoch.d/" common-lisp::*pathcldlo*))

;;   Permet de concatner les lments successifs d'un chemin d'accs menant 
;; un fichier. Un premier argument doit tre un PATHNAME ou une CHANE DE
;; CARACTRES racine. Au moins un autre argument CHANE DE CARACTRES. Rend un
;; nom de FICHIER sous forme de PATHNAME.
;; Exemple, common-lisp::*pathcldlo* tant un dossier pr-dfini :
;$   Zur Verkettung der aufeinanderfolgenden Elemente eines PATHNAMEs einer
;$ Datei. Das erste Argument muss ein Wurzel-PATHNAME oder eine ZEICHENKETTE
;$ sein. Bentigt mindestens ein weiteres ZEICHENKETTEn-Argument. Gibt den
;$ Name einer DATEI als PATHNAME zurck.
;$ Beispiel, mit einem vordefinierten common-lisp::*pathcldlo*-Ordner:
;+   Allows the concatenation of successive elements of a path leading to a
;+ file. A first argument must be a root PATHNAME or STRING. At least one
;+ further STRING argument. Returns a FILE name of type PATHNAME.
;+ Example, with a predefined common-lisp::*pathcldlo* folder:
;-   (cat-pathnames common-lisp::*pathcldlo* "Dos1" "Dos2" "Fic")
;-       => #P"/Volumes/DD/1DLO/cl.d/Dos1/Dos2/Fic"
(defun cat-pathnames (depart &rest frags)
  (when (pathnamep depart) (setq depart (namestring depart)))
  (when (char= (elt depart (1- (length depart))) #\/)
    (setq depart (delete #\/ depart :from-end t :count 1)))
  (labels ((interne (frgs ldr)
            (if (endp (cdr frgs))
              (concatenate 'string ldr "/" (car frgs))
            (interne (cdr frgs)
                     (concatenate 'string ldr "/" (car frgs))))))
  (make-pathname :name (interne frags depart))))

;;; UTILITAIRES ----------------------------------------------------------------
;$$ HILFSFUNKTIONEN ------------------------------------------------------------
;++ UTILITIES ------------------------------------------------------------------

;;   Pour tester rptitivement une valuation :
;;    continu <forme>   => boucle continue infinie sur <forme>
;;    pasapas <forme>   => boucle infinie sur <forme> avec attente d'un <RETURN>
;;                         ou d'un caractre quelconque pour chaque pas
;;   Dans les deux cas prcdents : faire <q><RETURN> pour interrompre.
;;    pressebouton <forme> => ouvre une fentre Presse Bouton. Evalue <forme> 
;;                            chaque clic sur son bouton Encore ou <RETURN>.
;;                            Cliquer sur son bouton Fini pour terminer
;;    iter <forme> &optional <n> => imprime <n> [ou 22] fois l'valuation de
;;                                  <forme>
;$   Zum repetitiven Testen einer Evaluation:
;$    continu <forme> => durchgehende endlose Schleife ber <forme> 
;$    pasapas <forme> => endlose Schleife ber <forme>, wartet fr jeden Schritt
;$                       auf ein <RETURN> oder einen anderen Buchstaben 
;$   In den beiden vorigen Fllen: <q><RETURN> drcken um abzubrechen.
;$    pressebouton <forme> => ein Presse Bouton-Fenster ffnen. Fhrt <forme>
;$                            mit jedem Klicken auf den Encore-Knopf oder
;$                            durch <RETURN> aus. Zum Beenden auf den
;$                            Fini-Knopf klicken
;$    iter <forme> &optional <n> => gibt <n> [oder 22] Male die Evaluation von
;$                                  <forme> aus
;+   To perform repetitive tests of some evaluation:
;+    continu <forme> => continuous infinite loop on <forme>
;+    pasapas <forme> => infinite loop on <forme>, waiting for a <RETURN> or
;+                       any other character for each step
;+   In both preceding cases: type <q><RETRUN> to quit.
;+    pressebouton <forme> => opens a Presse Bouton window. Evaluates <forme> on
;+                            every click on the Encore button or <RETURN>.
;+                            Click the Fini button to exit
;+    iter <forme> &optional <n> => prints <n> [or 22] times the evaluation of
;+                                  <forme>
(defmacro continu (forme)
  (format *debug-io* "~&Taper quelque chose, par ex. <g>, pour ~
                     commencer, et <q><RETURN> pour finir.~%")
  (read-char *debug-io* nil t t)
  (terpri)
  `(loop
     ,forme
     (when (equal #\q (read-char-no-hang *debug-io* nil t t))
       (return 'ok))))
(defmacro pasapas (forme)
  (format *debug-io* "~&Taper quelque chose, par ex. <RETURN>, pour ~
                     repeter, et <q> pour finir.~%")
  `(loop
     ,forme
     (when (char= #\q (read-char *debug-io* nil t t))
       (return 'ok))))
(defmacro pressebouton (forme)
`(defparameter common-lisp::*pressebouton*
      (capi::contain
       (make-instance 'capi::row-layout
         :description
         (list (make-instance 'capi::push-button
                              :data "Encore"
                              :visible-min-width 100
                              :default-p t
                              :callback
                              #'(lambda (&rest args) ,forme))
               (make-instance 'capi::push-button
                              :data "Fini"
                              :visible-min-width 100
                              :callback
                              #'(lambda (&rest args)
                                  (print 'ok) (terpri)
                                  (capi::apply-in-pane-process 
                                   common-lisp::*pressebouton*
                                   'capi::quit-interface
                                      common-lisp::*pressebouton*)
                                  (makunbound 'common-lisp::*pressebouton*)
                                  ))))
       :TITLE "Presse Bouton")))
(defmacro iter (forme &optional (nbr 22))
  `(do ((n 1 (1+ n)))
       ((> n ,nbr) 'ok)
     (format t "~5D :~10T~A~%" n ,forme)))

;;   Pour imprimer temporairement une valeur, en cours de mise au point :
;;    dbg <forme> => imprime la <forme> et son valuation sur *standard-output*
;$   Zur zeitweisen Ausgabe einer Evaluation whrend des Debuggens:
;$    dbg <forme> => gibt <forme> und seine Evaluation auf *standard-output* aus
;+   To temporarily print a value, while debugging:
;+    dbg <forme> => prints <forme> an its evaluation on *standard-output*
(defmacro dbg (forme &optional fonction)
  (if fonction
      `(format *standard-output* "~4Tdbg-> ~S : ~S = ~S~%"
               (quote ,fonction) (quote ,forme) ,forme)
    `(format *standard-output* "~4Tdbg-> ~S = ~S~%" (quote ,forme) ,forme)))

;;   Pour imprimer joliment -- <pretty-print> -- une liste de listes <lideli>.
;; La liste de listes est dcompose en lments par deux dolist imbriques.
;; La structure de parenthses est reconstitue par les primitives d'impression
;; format. On obtient une prsentation en matrice, plus lisible. Le mot-clef
;; :largeur [10 caractres par dfaut] permet de contrler l'espacement des
;; colonnes, sparateur(s) blanc(s) inclus.
;$   Um eine Liste von Listen <lideli> hbsch auszugeben -- <pretty-print>.
;$ Die Liste von Listen wird durch zwei verschachtelte dolist-Ausdrcke in
;$ Glieder zerteilt. Die Klammernstruktur wird durch das format-Ausgabeprimitive
;$ wiederhergestellt. Das Ergebnis ist eine lesbarere Matrix-Darstellung. Das
;$ Schlsselwort :largeur bestimmt die Weite der Spalten inklusive
;$ Zwischenraumzeichen [standardmig 10 Zeichen].
;+   To pretty-print a list of lists <lideli>. The list of lists is decomposed
;+ into elements by two nested dolist forms. The parenthesis structure is
;+ reconstructed by the format printing primitive. The result is a more legible
;+ matrix representation. The :largeur key-word [10 characters by default]
;+ controls the spacing of columns, blank separators included.  
;-    Exemple : /Beispiel: / Example:
;-              (setq ll '((A B C D) (1 2 3 4) (* + = !)))
;-              (jolilideli ll :largeur 3) => (
;-                                             (  A  B  C  D)
;-                                             (  1  2  3  4)
;-                                             (  *  +  =  !)
;-                                            )
;;   Aligne  droite par dfaut. Ajouter :gauche t pour aligner  gauche.
;$   Standardmig rechtsbndig. Fr linksbndig :gauche t hinzufgen.
;+   Right alignment by default. Add :gauche t to obtain a left alignment.
;-    Exemple : / Beispeil: / Example:
;-             (jolilideli ll :largeur 3 :gauche t) => (
;-                                                       (A  B  C  D  )
;-                                                       (1  2  3  4  )
;-                                                       (*  +  =  !  )
;-                                                      )
(defun jolilideli (lideli &key (largeur 10) gauche)
  (setq largeur (prin1-to-string largeur))
  (let ((cadena (concatenate 'string "~" largeur (if (not gauche) "@" "") "S")))
    (format t "~&(~%")
    (dolist (lali lideli)
      (format t " (")
      (dolist (lele lali)
        (format t cadena lele))
      (format t ")~%"))
    (format t ")~%")))

;-   Documentation strings
(defmacro dof (nom)
"
;    dof <sym> => documentation-string d'une variable, macro-fonction,
;                 fonction ou methode generique <sym>.
"
  `(format t "~A" (dofi ,nom)))
(defmacro dofi (nom)
  (cond ((boundp nom)
         `(format nil ";~A : variable : ~A" (quote ,nom)
                  (documentation (quote ,nom) 'variable)))
        ((macro-function nom)
         `(format nil ";~A : macro-fonction : ~A" (quote ,nom)
                  (documentation (quote ,nom) 'function)))
        ((fboundp nom)
         `(format nil ";~A : ~A : ~A" (quote ,nom) (type-of #',nom)
                  (documentation (quote ,nom) 'function)))
        ))

;;    partir de deux points [<x1>:<y1>] et [<x2>:<y2>], donne deux values : les
;; coefficients <a> et <b> de la fonction linaire y=ax+b passant par ces deux
;; points.
;$   Berechnet aus zwei Punkte [<x1>:<y1>] und [<x2>:<y2>] zwei Values: den <a>-
;$ und <b>-Koeffizienten der linearen Funktion y=ax+b, welche diese beiden
;$ Punkte enthlt.
;+   From two points [<x1>:<y1>] and [<x2>:<y2>] returns two values: the <a> and
;+ <b> coefficients of the linear function y=ax+b which includes these two
;+ points.
(defun y=ax+b (x1 x2 y1 y2)
  (let ((a (float (/ (- y2 y1) (- x2 x1)))))
    (values a (- y2 (* x2 a)))))

;;   Arrondi d'un nombre quelconque  4 dcimales au maximum.
;;   Le nombre de dcimales ne peut tre modifi, ni par un argument d'appel, ni
;; par un mot-clef : la fonction n'a pas de souplesse, mais son utilisation est
;; simplifie -- par exemple lorsqu'elle doit tre applique  une liste de
;; nombres avec la primitive mapcar.
;;    Exemple (dernier nombre = frquence du Do central) :
;$   Zur Rundung einer beliebigen Zahl auf hchstens 4 Dezimalstellen.
;$   Die Anzahl der Dezimalstellen ist weder mit einem Argument noch mit einem
;$ Schlsselwort vernderbar: die Funktion ist nicht flexibel, jedoch ihre
;$ Anwendung vereinfacht z. B. wenn sie mit dem mapcar-Primitive auf eine
;$ Zahlenliste angewendet werden soll.
;$   Beispiel (die letzte Zahl ist die Frequenz des mittleren C): 
;+   Rounding of any number to a maximum of 4 decimal places.
;+   The number of decimals can not be modified by an argument or key-word; the
;+ function is not adaptable, but its use is simplified, for instance when it is
;+ applied to a list of numbers by means of the mapcar primitive.
;+    For instance (last number = frequency of Middle C): 
;-    (mapcar #'trimfloat4 '(7/3 9321/623463 3.141592653589793 261.62556530059))
;-        => (2.3333 0.015 3.1416 261.6256)
(defun trimfloat4 (num)
  (/ (round (float num) 0.0001) 10000.0))

;;   Mme chose, avec nombre de dcimales en second argument optionnel [2 par
;; dfaut].
;$   Gleich, mit Nummer der Dezimalstellen im zweiten optionalen Argument [2
;$ defaultmig].
;+   Same thing, with number of decimal places as second optional argument [2 by
;+ default].
(defun trimfloatx (num &optional (nn 2))
  (/ (round (float num) (expt 10.0 (- nn))) (expt 10.0 nn)))

;;   Applique <fonction>  toutes les feuilles d'un <arbre>. Exemples, pour <a>
;; et <b> dfinis respectivement comme (1 2 3 4 5 6) et
;; (1 (2 (3)) 4 (5 6) 7 8) :
;$   Wendet <fonction> auf alle Bltter des Baums <arbre> an. Beispielsweise
;$ mit <a> und <b> je definiert als (1 2 3 4 5 6) und (1 (2 (3)) 4 (5 6) 7 8):
;+   Applies <fonction> to all the leaves of the <arbre> tree. Examples, for <a>
;+ and <b> defined as (1 2 3 4 5 6) and (1 (2 (3)) 4 (5 6) 7 8) respectively:
;-    (maparbre '1+ b) => (2 (3 (4)) 5 (6 7) 8 9)
;-    (maparbre '(lambda (x) (* x 10)) b) => (10 (20 (30)) 40 (50 60) 70 80)
;-    (maparbre 'prin1-to-string (cons (maparbre '(lambda (x) (* x 3)) b)
;-                                     (butlast a 3)))
;-        => (("3" ("6" ("9")) "12" ("15" "18") "21" "24") "1" "2" "3")
;-    (jolilideli (maparbre 'trimfloat4
;-                   (maparbre '(lambda (x) (/ x pi))
;-                      (interpolist '(5.5634 9.9231) '(-2.6687 -33.6667) 5))))
;-        => (
;-            (    1.7709    3.1586)
;-            (    1.1158   -0.3101)
;-            (    0.4607   -3.7789)
;-            (   -0.1944   -7.2477)
;-            (   -0.8495  -10.7164)
;-           )
;; quivalente  mapcar si <arbre> est une squence :
;$ Gleichwertig zu mapcar falls <arbre> eine Sequence ist:
;+ Equivalent to mapcar if <arbre> is a sequence:
;-    (mapcar #'<fonction> <sequence>) = (maparbre '<fonction> <sequence>)
(defun maparbre (fonction arbre)
  (labels ((xxx (rbr) (cond
             ((null rbr) ())
             ((atom rbr) (eval (list fonction rbr)))
             (t (cons (xxx (car rbr))
                      (xxx (cdr rbr)))))))
    (xxx arbre)))

;;   Produit une liste de nombres dans [<m>,<n>] par pas incrmentaux de <incr>
;; [diffrent de zro, 1 par dfaut]. Exemples :
;$   Berechnet eine Zahlenliste im Bereich [<m>,<n>] mit <incr> inkrementellen
;$  Schritten [ungleich null, standardmig 1]. Beispiele:
;+   Returns a list of numbers in [<m>,<n>] by <incr> incremental steps [non
;+ zero, 1 by default]. Examples:
;-    (range 0 19) => (0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19)
;-    (range -19 -8) => (-19 -18 -17 -16 -15 -14 -13 -12 -11 -10 -9 -8)
;-    (range -20 0 :incr 3) => (-20 -17 -14 -11 -8 -5 -2)
;-    (range 9 0 :incr -1) => (9 8 7 6 5 4 3 2 1 0)
;-    (range 3 -15 :incr -2) => (3 1 -1 -3 -5 -7 -9 -11 -13 -15)
;; Les appels incohrents produisent NIL :
;$ Inkonsistente Argumente ergeben NIL:
;+ Inconsistent arguments result in NIL:
;-    (range -20 9 :incr -1) => NIL
;-    (range 20 -9 :incr 2) => NIL
;-    (range 1 1) => NIL
;;   Remarques et dfauts inhrents :
;; - Il faut faire (1+ (floor...)) et non (ceiling ...) parce que
;;    (ceiling <k>) => <k> si <k> est entier
;$   Anmerkungen und innewohnende Mngel:
;$ - Man muss (1+ (floor...)) verwenden, nicht (ceiling ...) weil
;$    (ceiling <k>) => <k> falls <k> eine Ganzzahl ist
;+   Notes and inherent flaws: 
;+ - One must do (1+ (floor...)), not (ceiling ...) because
;+    (ceiling <k>) => <k> when <k> is integer
;; - Utilisable en nombres flottants :
;$ - Mit Fliekommazahlen nutzbar:
;+ - Usable with float numbers:
;-    (range -9.25 -10 :incr -0.15) => (-9.25 -9.4 -9.55 -9.7 -9.85 -10.0)
;-    (range 0 3.5 :incr 0.5) => (0.0 0.5 1.0 1.5 2.0 2.5 3.0 3.5)
;-    (range 0 -0.5 :incr -0.25) => (0.0 -0.25 -0.5)
;;   Mais attention, dans ce cas, aux erreurs dues aux imprcisions de calcul :
;$   Aber in diesem Fall muss man auf Fehler aufgrund der rechnerischen
;$ Ungenauigkeit von Fliekommazahlen achten:
;+   However, in such cases, beware of errors due to arithmetic approximations:
;-    (range -1 -.3 :incr .1)
;-        => (-1.0 -0.9 -0.8 -0.7 -0.6 -0.5 -0.39999998 -0.3)
;;   Dans l'exemple ci-dessus -0.4 est approxim.
;$   Im vorigen Beispiel wird -0.4 nur nherungsweise dargestellt. 
;+   In the preceding example -0.4 is approximated.
;; - Il n'est pas utile de remplacer la multiplication (* i incr) par une somme
;;   cumule : cela modifie ventuellement les imprcisions de calcul, mais ne
;;   finit que par remplacer certains inconvnients par d'autres.
;; Inspir de la primitive homonyme en Python.
;$ - Es ist sinnlos die Multiplikation (* i incr) durch eine kumulative
;$   Summe zu ersetzen: es ndert mglicherweise etwas an der Ungenauigkeit,
;$   aber letztendlich werden nur einige Nachteile durch andere ersetzt.
;$ Inspiriert von der gleichlautenden Funktion in Python.
;+ - It is useless to replace the (* i incr) multiplication by a cumulative
;+   summ: it eventually modifies arithmetic approximations, but finally only
;+   trades some inconveniences for others.
;+ Inspired by the homonym primitive in Python.
(defun range (m n &key (incr 1))
  (let (rez)
    (dotimes (i (if (= m n) 0 (1+ (floor (/ (- n m) incr)))) (reverse rez))
      (push (+ m (* i incr)) rez))))
       
;;   Utilit incontestable... De Le_LISP.
;$   Fraglos ntzlich... Aus Le_LISP.
;+   Indisputably useful... From Le_LISP.
(defmacro setqq (var val)
  `(setq ,var (quote ,val)))

;;   Utilitaire d'impression d'une squence quelconque de formes en une seule
;; ligne de texte.
;;    prins {<frms>}* => impression squentielle de(s) <frms>
;$   Hilfsfunktion um eine Folge von Ausdrcken in einer einzigen Zeile
;$ auszugeben.
;$    prins {<frms>}* => sequentiellen Ausdruck der <frms>
;+   Utility for the printout of any sequence of forms on a single line of text.
;+    prins {<frms>}* => sequential printout of <frms>
;- Exemple : / Beispiel: / Example:
;-    (prins "Variable a = " a ". Mais b = " b ".").
(defun prins (&rest frms)  ;fonction interface :  limination du cas trivial, et
  (if (endp frms) nil      ;emballage du nombre inconnu de forme(s) en une liste
      (labels ((prinsX (li)                             ;fonction effective
                 (cond    ((endp li) (terpri) 'ok)      ;cas terminal
                          (t    (princ (car li))        ;imprimer la premiere...
                                (prinsX (cdr li))))))   ;... et continuer
        (prinsX frms))))                                ;corps du labels         
;;   Pour obtenir la date, sous forme d'une chane de caractres
;;    "Jour de la semaine, tantime/mois/anne, heures:minutes:secondes"
;; Possibilit de formatage  l'anglaise ou allemande avec un argument optionnel
;; e ou d respectivement [f ( la franaise) par dfaut].
;$   Gibt das Datum in Form einer Zeichenkette aus
;$    "Wochetag, Tag.Monat.Jahr, Stunden:Minuten:Sekunden"
;$ Ermglicht die Ausgabe des Namens des Wochetags auf englisch oder deutsch mit
;$ einem optionalen Argument e oder d [standardmig f (franzsisch)].
;+   To obtain the date, as a character string
;+    "Week day, month/day/year, hours:minutes:seconds"
;+ Possibility of English or German week day's name and format with an optional
;+ argument e or d respectively [f (French) by default].
(defmacro jour-date (&optional (langue 'f) &aux separ jour)
  (let ((time (multiple-value-list (get-decoded-time))))
    (setq separ (if (eq 'd langue) "." "/"))
    (setq premi (if (eq 'e langue) (nth 4 time) (nth 3 time)))
    (setq secon (if (eq 'e langue) (nth 3 time) (nth 4 time)))
    (cond ((eq 'f langue) (setq jour (nth (nth 6 time)
            '("Lundi" "Mardi" "Mercredi" "Jeudi" "Vendredi" "Samedi"
              "Dimanche"))))
          ((eq 'd langue) (setq jour (nth (nth 6 time)
            '("Montag" "Dienstag" "Mittwoch" "Donnerstag" "Freitag"
              "Samstag" "Sontag"))))
          ((eq 'e langue) (setq jour (nth (nth 6 time)
            '("Monday" "Tuesday" "Wednesday" "Thursday" "Friday"
              "Saturday" "Sunday"))))
          (t (error "jour-date : langue inconnue : ~A." langue)))
    (format nil "~A, ~2,'0D~A~2,'0D~A~4D, ~2,'0D:~2,'0D:~2,'0D"
                jour
                premi separ secon separ (nth 5 time)
                (nth 2 time) (nth 1 time) (nth 0 time))))

;;   Interaction avec l'utilisateur : interrogation suivie d'une lecture de la
;; rponse. Cf. aussi les primitives yes-or-no etc. [CLtL2:609sq.] et ped.14.
;;    ?? "<message>" => impression de <message> suivi d'un " ?", sur *query-io*,
;;                      et cho de la rponse attendue de l'utilisateur
;$   Benutzerinteraktion: Frage gefolgt vom Einlesen der Antwort. Siehe auch die
;$ yes-or-no-Primitives usw. [CLtL2:609sq.] und ped.14.
;$    ?? "<message>" => Ausgabe von <message> gefolgt von " ?", auf
;$                      *query-io*, und Rckgabe der erwarteten Antwort des
;$                      Benutzers
;+   User interaction: printed query followed by reading the user's answer. Cf.
;+ also the yes-or-no primitives etc. [CLtL2:609sq.] and ped.14.
;+    ?? "<message>" => printout of <message> followed by " ?", on *query-io*,
;+                      and echo of the answer expected from the user
(defun ?? (msg)
  (princ msg *query-io*)                                ;impression du <message>
  (princ " ? " *query-io*)                              ;suivi de " ? "
  (read *query-io*))                                    ;valeur lue => rendue

;;   Interaction avec l'utilisateur : interrogation et lecture de la reponse.
;; Cf. ?? ci-dessus, modifie pour rendre la valeur <defaut> lorsque la rponse
;; est un <RETURN> seul.
;$   Benutzerinteraktion: Frage gefolgt vom Einlesen der Antwort. Siehe oben,
;$ verndert um die Standardantwort <defaut> zurckzugeben falls nur <RETURN>
;$ geantwortet wurde.
;+   User interaction: query and reading of the answer. Cf. above, modified to
;+ render the <defaut> default value, when the answer is only <RETURN>.
(defun ??defaut (msg defaut &aux str)
  (terpri)(terpri)
  (princ msg *query-io*)
  (princ " -- par defaut : " *query-io*)
  (princ defaut *query-io*)
  (princ " ? " *query-io*)
  (setq str (read-line *query-io*))
  (if (zerop (length str)) defaut
      (read-from-string str)))

;;   Teste si <list> est circulaire ou non.
;$   Prft ob <list> kreisfrmig ist oder nicht.                      [d..F.Z.]
;+   Tests if <list> is circular or not.

(defun circularp (list)
  (let ((OrigVal *print-circle*))
    (prog2 (setq *print-circle* t)
           (when (search "#1=" (format nil "~A" list)) t)
           (setq *print-circle* OrigVal))))

;;   Donne les <n> premiers lments de <list>, mme si cette liste est
;; circulaire. Donne <list> dans le cas o celle-ci comporte moins de <n>
;; lments.
;$   Gibt die ersten <n> Elemente von <list> zurck, auch wenn die    [d..F.Z.]
;$ Liste kreisfrmig ist. Gibt <list> zurck, wenn sie weniger als <n> Elemente
;$ hat.
;+   Returns the <n> first elements of <list>, even if this list is circular.
;+ Returns <list> when the latter counts less than <n> elements.

(defun nfirstn (list &optional (n 1) &aux rez)
  (do ((cmpt 0 (1+ cmpt)))
      ((or (= n cmpt) (endp list)) (reverse rez))
    (push (pop list) rez)))

;;   Chargement de l'interface de notation musicale LilyPond.
;$   Laden des Interfaces zur LilyPond-Musikalischenotation.
;+   Load interface to LilyPond musical notation.

(load (cat-pathnames common-lisp::*pathcldlo* "LilyPond" "Lilypond.lisp"))

;-   "Documentation"
(defparameter Doc.
  "Liste des chapitres de Doc. charges (symboles) : Doc.Clinit")
(defparameter Doc.Clinit (format nil "~&;; Definitions
;    common-lisp::*pathcldlo*         => dossier <origine> de +clinit.cl
;    common-lisp::*path-ped*          => <origine>/ped.d
;    common-lisp::*path-stochastique* => <origine>/stoch.d
;; Fonctions diverses...
;    cat-pathnames <r> {<d>}* <f> => #P\"<r>/<d1>/.../<dN>/<f>\" = path fic. <f>
;    continu <forme>              => boucle continue infinie sur <forme>
;    pasapas <forme>              => boucle inf. <forme> + <RETURN> pas/pas
;        Dans les deux cas precedents : faire <q><RETURN> pour interrompre
;    pressebouton <forme>         => repete <forme> sur clic bouton
;    iter <forme> [(<n> 22)]      => <n> evaluations de <forme>
;    dbg <forme> [<fonction>]     => <forme> et son eval. sur *debug-io*
;    jolilideli ll [:largeur (<n> 10)] [:gauche t] => ...
;    dof <sym>                    => documentation string de <sym>
;    y=ax+b x1 x2 y1 y2 => <a> et <b> de ax+b avec [<x1>:<y1>] et [<x2>:<y2>]
;    trimfloat4 <num>             => <num> a 4 decimales
;    trimfloatx <num> [(<nn> 2)]  => <num> a <nn> decimales
;    maparbre '<f> <arb>          => applique <f> a toutes les feuilles de <arb>
;    range <m> <n> [:incr (<i> 1)]=> liste de nombres [<m>,<n>] par pas <incr>
;    setqq <x> <y>                => (setq <x> '<y>)
;    prins {<forme(s)>}*          => impression sequentielle de(s) <forme(s)>
;    jour-date [[f] | d | e ]     => ...
;    ?? \"<message>\"             => interroge et rend la reponse
;    ??defaut \"<message>\" <dft> => idem ?? mais rend <dft> si reponse nulle
;    circularp <li>               => T/NIL
;    nfirstn <li> [(<n> 1)]       => <n> 1-ers elements de <li> meme circulaire
;    lily <hts> [<durs>]          => notation music. LilyPond (<hts> en NumNot)
;; Documentation (symboles)
;    Doc. (symb.)                 => liste des chapitres de Doc. charges
;    Doc.Clinit (symb.)           => ceci
"))
(format t "~A" Doc.Clinit)

;;   En cas de chargement d'un fichier isol de la bibliothque stochastique,
;; sans en passer par le module (i.e. le fichier canons_base), il sera
;; quand-mme possible d'en concatner la documenation  Doc.Stoch.
;$   Falls eine einzelne Datei der stochastischen Bibliothek geladen wird ohne
;$ das Modul zu benutzen (d. h. die canons_base-Datei), ist es trotzdem mglich,
;$ seine Dokumentation mit Doc.Stoch zu verketten.
;+   When loading an isolated file from the stochastic library, without using
;+ the module (i.e. the canons_base file), it will nevertheless be possible to
;+ concatenate its documentation to Doc.Stoch.
(defparameter Doc.Stoch "")

;;   Demande si le fichier d'initialisation +clinit.lisp des exemples
;; pdagogiques doit tre charg. Ne sera charg que si l'utisateur rpond
;; prcisment "o" ou "O".
;$   Fragt, ob die Initialisierungsdatei +clinit.lisp der pdagogischen
;$ Beispiele geladen werden soll. Geladen wird sie nur wenn der Benutzer genau
;$ "o" oder "O" antwortet.
;+   Asks if the initialization file +clinit.lisp of the pedagogical examples
;+ should be loaded. Loaded only if the user responds precisely "o" or "O".
;!
;! ATTENTION :
;!   Interrogation pour chargement du fichier d'initialisation pdagogique :
;! utilisable dans l'initialisation de LispWorks SEULEMENT  partir d'un
;! shell-script ! En lancement par double-clic, le fichier d'initialisation
;! est excut AVANT le lancement de l'IDE (Interactive Development Interface
;! i.e. fentres, outils, etc.) => *query-io* n'est pas encore disponible => la
;! fonction ??defaut provoque un blocage.
;!    Martin Simmons, de l'quipe LispWorks m'a transmis ce code qui permet
;! d'imprimer et interroger dans le Listener ds le fichier d'initialisation :
;!    (defun my-listener-inits ()
;!      (format t "This is output ~%")
;!      (format *query-io* "Enter a line: ")
;!      (read-line *query-io*))
;!    (define-action "Initialize LispWorks Tools" "My inits"
;!      #'(lambda (screen)
;!          (capi:interactive-pane-execute-command
;!           (capi:editor-pane
;!             (capi:find-interface 'lw-tools:listener :screen screen))
;!        "(cl-user::my-listener-inits)")))
;! Marche bien, mais je ne l'ai pas implment car il me semble trop spcifique
;!  LispWorks. Je prfre en rester  un shell-script de lancement. Dans ce cas
;! les impressions et interrogations ont lieu dans la fentre UNIX avant le
;! dpat de l'IDE.
(let ((fichier (merge-pathnames "+clinit.lisp" common-lisp::*path-ped*)))
  (when (equal 'O (??defaut (format nil "~&;Chargement \"ped\" normal (~S) ~
                                        :~%O(Oui)/N(Non)" fichier)
                            'N))
    (load fichier)))

(format t "~&;Salut, t'es ~A.~%" (jour-date))
