;; N.B. : VERSION AVEC VRAIE-TEMPORISATION, fichier epicycles-CAPI.clce.lisp
;; LispWorks affiche "en temps rel", que l'valuation ait lieu dans le
;; LISTENER ou dans une fentre EDITOR.

;;   Charger fichier epicycle-CAPI.lisp, qui contient toutes les fonctions
;; ncessaires. Ne dpend d'aucun autre fichier.
;;   Les exemples ci-dessous proviennent pour partie de ce mme fichier.

;;   Il arrive que LispWorks refuse de traiter avec apply une liste trop longue.
;; Ceci se passe sans doute dans la normalisation des listes de coordonnes par
;; trnormalili, mais n'est pas directement caus par mon code LISP. Pour viter
;; ce problme, il faudrait calculer les coordonnes au vol, au fur et  mesure,
;; et non pas toutes les prparer et normaliser d'avance dans une (mga)liste.
;;   Pour cette raison, les dures et/ou finesses d'chantillonnage sont parfois
;; limits ci-dessous. 

;;   Fonction interface finale...
;;    (Ptolemee <rayons> <secspartour> <angles> <dure> [<echparsec>])
;;        o echparsec = 10 par dfaut
;; Les dures sont des secondes **relles**, pour autant que la fonction
;; LispWorks mp::process-wait-with-timeout le permette.

;; Exemples simples

;Un dfrent, un tour sens ngatif en 7.5 sec. chantillonn au 1/10 sec.
(ptolemee '(1) '(-7.5) '(225) 7.5)
;Un dfrent, un tour sens ngatif en 7.5 sec. chantillonn au 1/20 sec.
(ptolemee '(1) '(-7.5) '(225) 7.5 20)
;Un dfrent lent, un picycle plus rapide
(ptolemee '(1 0.3) '(12.05 -0.91) '(0 90) 22.05 50)
;Type plantaire
(ptolemee '(1 0.3) '(2.05 -1.76) '(0 90) 20.5 40)
(ptolemee '(1 0.2 0.05) '(2.05 -2.15 2.33) '(0 -90 187) 6.5 80)
;Goutte
(ptolemee '(25 1181/60 394/60) '(5 -5 2.5) '(110 110 40) 5 50)
;Banane
(ptolemee '(25 1181/60 394/60) '(5 -5 2.5) '(0 90 33) 5 50)
;Ovode
(ptolemee '(25 606/60 202/60) '(5 -5 2.5) '(90 90 170) 5 50)
;Spirale / Spoutnik / Atomic Sixties ; n.b. : changements de sens...
(ptolemee '(1 1.2 0.35) '(2.05 -2.15 2.33) '(0 -90 187) 25.5 80)
;Loopings doubles rguliers rosace : dmo
(ptolemee '(1 0.2 0.05) '(10 -0.67 0.13) '(44 266 -21) 20.1 100)

;; Alatoires
;;    (PtolAlea [(nbr_de_cercles 3)])
;; Ci-dessous :
;;    appels possibles : (PtolAlea <n>)
;;    qqs rsultats obtenus...
;; (PtolAlea 3)
;semble discontinu (ptolemee '(0.8019117169117773 0.43210358439405183 0.27782830461455194) '(0.026469240014384 2.573573510299574 -3.084029924280997) '(198.72751362384764 70.80550423042011 132.1923342574245) 10 100)
;idem + long (ptolemee '(0.8019117169117773 0.43210358439405183 0.27782830461455194) '(0.026469240014384 2.573573510299574 -3.084029924280997) '(198.72751362384764 70.80550423042011 132.1923342574245) 20 100)
;idem + fin (ptolemee '(0.8019117169117773 0.43210358439405183 0.27782830461455194) '(0.026469240014384 2.573573510299574 -3.084029924280997) '(198.72751362384764 70.80550423042011 132.1923342574245) 10 200)
;panoramiques... Homme de Vitruve (ptolemee '(0.8825226610200901 0.32544866264881317 0.7303336965485172) '(2.3046545261603866 3.2078479010757945 -3.0089195035564145) '(336.5942548524481 294.2559334901272 352.4489747592229) 40 50)
;; (PtolAlea 7)
;Brancusi (ptolemee '(0.3794871557121857 0.23521346270146493 0.4685317510152827 0.31362773722713394 0.8486033842872891 0.8123680144778789 0.05733525204907219) '(-4.1499377212486 4.780147093870021 -2.6877651506807005 2.76682732210835 3.903727454885333 4.890347551350198 4.433737768668193) '(14.804973704377142 115.97297473991844 62.487074849171705 199.9586267768566 113.88621612244513 312.34747691517225 345.13801661345735) 10 50)
;flamenco (ptolemee '(0.9042130967680608 0.8928239753336161 0.03735396272941299 0.14648299877808058 0.6906421830703359 0.8905453419136728 0.9648037999212813) '(3.662636147183619 1.6209892306867788 2.928489088878946 3.1705931726295375 -0.9982210136916878 -2.9349149538854418 -4.370071011353416) '(169.5647233157693 53.86041539508927 276.9392923208685 133.85762329000536 182.7912156708375 3.9526688381147923 93.0690293257479) 10 50)
;couple (ptolemee '(0.8358049855303112 0.44166507281673156 0.8952233882531959 0.30941846465583606 0.021542564074588127 0.14490163912047005 0.42870782209319586) '(3.0132167190559525 0.8626941514437911 2.580734747612354 0.55342487162617 2.605803623061261 -1.3212723030173636 -3.0013052336895933) '(9.995903689406633 182.53585193778545 196.97053998144443 236.4779902183972 326.6587685917668 290.2260203850009 338.28118126519246) 10 100)
;; (PtolAlea 8)
;OVNI de biais (ptolemee '(0.9426193944041047 0.9084301943116453 0.35745926640454545 0.42035224553263234 0.07050488902349936 0.3354040334660635 0.6135867249473682 0.8180131033398456) '(-4.912857897417355 -0.8616859575019884 1.721689676347542 4.780077058412278 3.6279522415771197 -3.451220204031505 2.449691514390877 -4.0833511931511595) '(0.042824149211541096 150.04706544810358 325.69810324478544 214.03781282536278 211.01702587868465 260.2247950066343 93.28077229350949 184.59807370714486) 10 50)
;H (ptolemee '(0.12829675735588514 0.7016738964275903 0.2766546742555772 0.0082435235534674 0.5088153137058304 0.4023546528115024 0.09067872556052865 0.8099069442784543) '(-3.967896977379726 -1.7964075259797414 0.9419843665174854 -2.0046616103586956 -4.803201537212733 0.7307090344479477 3.793797341722618 4.842736813878151) '(200.21877758245685 181.05812844086088 21.2090401001443 359.20901656003485 93.39492979160497 289.64459458299837 354.53265285963687 63.54903180813236) 10 50)
;; (PtolAlea 11)
;Sixties (ptolemee '(0.31939640886969195 0.20994810799127092 0.8438184332918719 0.41040879378171413 0.9770351405759066 0.514676391174414 0.2996348893263096 0.6359817285760897 0.7621398619602245 0.6114171661649219 0.8144683126629672) '(-4.5941710650812295 -1.8456606135622793 4.748348928519244 -4.368127043113349 1.309021741727408 1.3727777011185474 3.841417373793977 1.3521528548601136 2.3175827177568955 -0.8553303514706538 2.6135591931893662) '(136.03041175013485 229.8835433086074 303.74869164777675 7.1324732287460435 34.92845742949929 120.16795367033771 232.48722462446844 324.8842298330445 40.19439682400673 302.2897717771861 224.9572848993489) 10 50)
;L'angle (ptolemee '(0.5691625374726254 0.27213126657927644 0.5386914173861805 0.7942020013820418 0.30518456232768404 0.12020113900341306 0.570299415980092 0.9967150576351491 0.47167077748416136 0.3721157747732769 0.7849426638054525) '(2.7060986826309907 0.8028053414128822 4.806125536199893 1.6921532278734315 -2.0418370273743514 -0.72346172430266 3.6612500411667863 4.714048280779362 -4.333393609772238 2.5757075428510223 -3.611363300329751) '(59.92708068327435 321.95332706338417 326.21125475729116 40.25950543630776 67.62375993211523 277.2228909977207 182.6893782293226 192.98802419190858 195.95809056602064 202.0283252038589 203.25777874003683) 10 50);; (PtolAlea 16)
;; (PtolAlea 16)
;crazy partout (ptolemee '(0.913140561269858 0.3792067065447694 0.8563165717875894 0.9719211942924582 0.7434450252790843 0.07954742215489488 0.867079347124471 0.5338476515074216 0.31590470730495585 0.8047832321464703 0.8579157085305372 0.35107646202869053 0.1874410047893245 0.9497020150529258 0.2390942335856971 0.2833560244801566) '(3.953601250338556 -0.8867523742592933 1.344354704663818 -3.8653906413640655 2.0143751744448677 -1.604715784275375 -2.3272695901380285 -0.20367042199460883 3.0226775780742567 1.0842138269622135 1.3098633034338487 0.9259024372806826 -3.1108178163148796 3.2023194957567753 -1.6004344385125386 -2.358693140295694) '(173.68508520291203 283.93303499358336 262.55720776050765 128.2023639384701 320.441815779436 175.7917042370731 167.62945385208252 216.50884951745877 196.53971351038612 185.1145209839838 182.11168807393256 207.7482774252971 101.68173324629987 272.9219279306418 187.13315819787448 155.68250193387738) 20 100)
;silhouettes (ptolemee '(0.6675077745085727 0.8319163058547607 0.8293517061124588 0.8026733748664584 0.08246904068155035 0.23521212159695498 0.31578493735899205 0.8432469849348944 0.4968376951233255 0.5376570942581763 0.8678400122892856 0.42043211948207043 0.3021229790563192 0.3583750079541933 0.7042537158434349 0.7589981719087775) '(3.26261616919677 2.456439188600404 -4.780335500427215 2.5471979892760475 1.219031040033384 -1.3241448929983095 -1.6161186557563365 -1.297764212447711 -4.56535369076832 -2.1317136047998697 2.9657032302873265 -0.426251581732652 4.491626898742517 -0.30483118315195945 2.139594791717072 1.3055487467079399) '(294.34144834865157 57.173306973973865 113.29231000187306 79.230033083316 232.7274332060058 231.74517272365313 84.86585245442735 268.08274475500497 234.1040629038663 118.95172945959816 114.9278526658711 60.27341019413138 63.32507271938971 348.7026234505747 231.25624960522399 188.27054557999696) 20 50)
;; (PtolAlea 87)
;prolifration erratique (ptolemee '(0.384334609628347 0.13855612490057223 0.767863807767376 0.7890795353596649 0.31084775982582524 0.029191341305507983 0.6517475818316407 0.9711035787520996 0.2555692889831388 0.555320956847297 0.34298749704470394 0.7242131656486787 0.6375201151473823 0.14463477794944268 0.9203810336447898 0.43116879543507247 0.5367027419371582 0.3496508195058458 0.6641286400409949 0.8920457696393985 0.4851300688183495 0.41885501224334354 0.5769036162214422 0.16266891018053314 0.8489929248560089 0.03950961686579439 0.3973619293372369 0.9188798403719065 0.2502571609807334 0.6539937363080564 0.4962670216267314 0.5059397155529628 0.22328271944687278 0.8978511372541098 0.440324562490591 0.15741383872444525 0.8035943113334371 0.5393466233077396 0.48745080174403416 0.6764301744781996 0.0971344506314666 0.6310738243741427 0.8054008238118158 0.8884949011513869 0.13246374601957156 0.6782562726703589 0.3805096007520512 0.3973976176183626 0.7446140195142739 0.2405262389043835 0.6492747061872384 0.530835679789699 0.5337766362983298 0.33335135752959427 0.9417563116955688 0.6687155806808092 0.6141212482268387 0.10044388864272068 0.736941918240752 0.8019073620474103 0.9587253275489906 0.3592570635662546 0.21020008849017338 0.238704883006783 0.7446093982916501 0.7867486845455108 0.1519520509093107 0.8062923770515106 0.20607932322859637 0.5661100252831541 0.37105154873999124 0.8126495085892258 0.7462698868406376 0.14682495807637452 0.888762101323832 0.6667498325309713 0.33743078324465225 0.18189374018813248 0.21253081450710226 0.4457890660423582 0.42100346725620974 0.1853399857605621 0.6818923534488163 0.052277745776395775 0.9668168927856104 0.48056582264707576 0.685070584872869) '(-1.49367894324228 -1.223812804042944 1.4727397942407796 -0.5349931410234294 4.928700290487521 4.339011515190846 -1.0049936659727128 4.886099491056241 3.280092791244561 -1.9398893731457916 1.8012692533457075 -2.1729256532582 3.7373283668185184 -3.9789317342991604 -3.1580384041332423 -3.7998312130567267 -3.9911278318448513 -4.701755176674118 -0.978658918251579 -2.90905229357826 -2.348535335340603 3.0455402807249516 3.660579135009236 0.81164670327985 1.054708987576345 -0.5506416327331989 -0.11697880014214412 1.3596020757399536 -0.2616689265922991 -1.4769051903428605 -4.21056037621677 -0.9873324930431924 -1.2850297545735345 0.30284867678368244 -3.674596508358785 3.1549136306250727 1.0336295255154928 0.7106759133016238 -3.3569700799080917 -3.31446258037251 0.8468396698065837 -4.460386204459493 -4.855466484754284 3.3979015767535223 -3.2126103867080253 0.08834506401483821 3.4468117327369967 -4.337591546285137 -0.055267857490606254 -2.770873602052915 1.9902414772477774 4.443140755301604 4.7001399094241485 -2.7088359328151417 4.925435576449029 3.334821254638623 3.1703038479579675 0.9268485865124472 -3.33032393517033 -2.0888062512293577 1.97486027511742 -4.935491233943945 -4.141272789130495 -1.2527211871980155 -2.08501452037136 1.2429845449384018 -3.3635671778834744 0.5165157942408989 3.988341500960926 0.35693635299231197 3.045987110670632 -2.6025208041118844 -4.671322758628657 -0.22783751641928696 2.378326556418699 4.691010582616572 -0.8807835651203684 -2.48388129749127 -2.579786139688988 -0.8817762246015972 0.6121266179012625 0.047074733389679935 1.760996313320467 -4.964357539945016 3.485998247724023 -3.234732352634393 -2.937420323374533) '(82.05120399976373 263.91630519910956 297.22926478316873 146.08878945203273 327.40923055896394 250.9470943565426 156.25255248742653 189.6130522147064 258.3695204153089 11.711020789502227 214.624087390721 7.046797437680508 33.776565331549506 218.6740701248386 111.06953120058316 331.07636215365744 211.05798790428412 160.57747706878462 348.3386041006793 304.4352291979552 116.55262693120656 312.63073696313563 240.00122666359178 359.97510977084767 252.608976313116 152.88827850090019 124.25799452561513 190.9637784789573 116.31504423229964 295.31677800289685 24.045472785915198 297.5281031011196 318.8344711788641 292.2962780525839 203.29763234275882 189.02762120408497 313.8065972808871 63.358272432085634 232.26165621031384 92.08916338549771 209.6222154975351 170.79154895765996 7.283545969582248 29.382963458789444 233.13468708309287 149.2263376512124 206.73332282664873 89.10618016329813 324.0893256740446 256.93863901670767 157.3398435811323 90.15113728149075 82.76663966992244 196.64842143030543 176.2518861447496 23.63236565819451 184.2185337547558 107.79907015673643 147.717011026511 184.90427267719858 128.03349205857793 132.2780569871479 351.62539175083003 102.34744277288661 163.2834296734695 192.37794971536462 57.43041615454558 262.1350307429862 153.12637417228217 312.49314500483337 300.60325507186957 285.3394687275206 184.37701341580043 352.92131579093876 290.13910809557717 111.05576677444535 280.60062095634754 33.8506512974401 99.59026332868312 197.51166291071414 162.1609359274822 250.918253233504 40.08758857862575 56.21392439345629 263.01204469615976 27.86162120823119 266.3881499066728) 10 50)
;idem + fin (ptolemee '(0.384334609628347 0.13855612490057223 0.767863807767376 0.7890795353596649 0.31084775982582524 0.029191341305507983 0.6517475818316407 0.9711035787520996 0.2555692889831388 0.555320956847297 0.34298749704470394 0.7242131656486787 0.6375201151473823 0.14463477794944268 0.9203810336447898 0.43116879543507247 0.5367027419371582 0.3496508195058458 0.6641286400409949 0.8920457696393985 0.4851300688183495 0.41885501224334354 0.5769036162214422 0.16266891018053314 0.8489929248560089 0.03950961686579439 0.3973619293372369 0.9188798403719065 0.2502571609807334 0.6539937363080564 0.4962670216267314 0.5059397155529628 0.22328271944687278 0.8978511372541098 0.440324562490591 0.15741383872444525 0.8035943113334371 0.5393466233077396 0.48745080174403416 0.6764301744781996 0.0971344506314666 0.6310738243741427 0.8054008238118158 0.8884949011513869 0.13246374601957156 0.6782562726703589 0.3805096007520512 0.3973976176183626 0.7446140195142739 0.2405262389043835 0.6492747061872384 0.530835679789699 0.5337766362983298 0.33335135752959427 0.9417563116955688 0.6687155806808092 0.6141212482268387 0.10044388864272068 0.736941918240752 0.8019073620474103 0.9587253275489906 0.3592570635662546 0.21020008849017338 0.238704883006783 0.7446093982916501 0.7867486845455108 0.1519520509093107 0.8062923770515106 0.20607932322859637 0.5661100252831541 0.37105154873999124 0.8126495085892258 0.7462698868406376 0.14682495807637452 0.888762101323832 0.6667498325309713 0.33743078324465225 0.18189374018813248 0.21253081450710226 0.4457890660423582 0.42100346725620974 0.1853399857605621 0.6818923534488163 0.052277745776395775 0.9668168927856104 0.48056582264707576 0.685070584872869) '(-1.49367894324228 -1.223812804042944 1.4727397942407796 -0.5349931410234294 4.928700290487521 4.339011515190846 -1.0049936659727128 4.886099491056241 3.280092791244561 -1.9398893731457916 1.8012692533457075 -2.1729256532582 3.7373283668185184 -3.9789317342991604 -3.1580384041332423 -3.7998312130567267 -3.9911278318448513 -4.701755176674118 -0.978658918251579 -2.90905229357826 -2.348535335340603 3.0455402807249516 3.660579135009236 0.81164670327985 1.054708987576345 -0.5506416327331989 -0.11697880014214412 1.3596020757399536 -0.2616689265922991 -1.4769051903428605 -4.21056037621677 -0.9873324930431924 -1.2850297545735345 0.30284867678368244 -3.674596508358785 3.1549136306250727 1.0336295255154928 0.7106759133016238 -3.3569700799080917 -3.31446258037251 0.8468396698065837 -4.460386204459493 -4.855466484754284 3.3979015767535223 -3.2126103867080253 0.08834506401483821 3.4468117327369967 -4.337591546285137 -0.055267857490606254 -2.770873602052915 1.9902414772477774 4.443140755301604 4.7001399094241485 -2.7088359328151417 4.925435576449029 3.334821254638623 3.1703038479579675 0.9268485865124472 -3.33032393517033 -2.0888062512293577 1.97486027511742 -4.935491233943945 -4.141272789130495 -1.2527211871980155 -2.08501452037136 1.2429845449384018 -3.3635671778834744 0.5165157942408989 3.988341500960926 0.35693635299231197 3.045987110670632 -2.6025208041118844 -4.671322758628657 -0.22783751641928696 2.378326556418699 4.691010582616572 -0.8807835651203684 -2.48388129749127 -2.579786139688988 -0.8817762246015972 0.6121266179012625 0.047074733389679935 1.760996313320467 -4.964357539945016 3.485998247724023 -3.234732352634393 -2.937420323374533) '(82.05120399976373 263.91630519910956 297.22926478316873 146.08878945203273 327.40923055896394 250.9470943565426 156.25255248742653 189.6130522147064 258.3695204153089 11.711020789502227 214.624087390721 7.046797437680508 33.776565331549506 218.6740701248386 111.06953120058316 331.07636215365744 211.05798790428412 160.57747706878462 348.3386041006793 304.4352291979552 116.55262693120656 312.63073696313563 240.00122666359178 359.97510977084767 252.608976313116 152.88827850090019 124.25799452561513 190.9637784789573 116.31504423229964 295.31677800289685 24.045472785915198 297.5281031011196 318.8344711788641 292.2962780525839 203.29763234275882 189.02762120408497 313.8065972808871 63.358272432085634 232.26165621031384 92.08916338549771 209.6222154975351 170.79154895765996 7.283545969582248 29.382963458789444 233.13468708309287 149.2263376512124 206.73332282664873 89.10618016329813 324.0893256740446 256.93863901670767 157.3398435811323 90.15113728149075 82.76663966992244 196.64842143030543 176.2518861447496 23.63236565819451 184.2185337547558 107.79907015673643 147.717011026511 184.90427267719858 128.03349205857793 132.2780569871479 351.62539175083003 102.34744277288661 163.2834296734695 192.37794971536462 57.43041615454558 262.1350307429862 153.12637417228217 312.49314500483337 300.60325507186957 285.3394687275206 184.37701341580043 352.92131579093876 290.13910809557717 111.05576677444535 280.60062095634754 33.8506512974401 99.59026332868312 197.51166291071414 162.1609359274822 250.918253233504 40.08758857862575 56.21392439345629 263.01204469615976 27.86162120823119 266.3881499066728) 10 200)
;encore + fin (ptolemee '(0.384334609628347 0.13855612490057223 0.767863807767376 0.7890795353596649 0.31084775982582524 0.029191341305507983 0.6517475818316407 0.9711035787520996 0.2555692889831388 0.555320956847297 0.34298749704470394 0.7242131656486787 0.6375201151473823 0.14463477794944268 0.9203810336447898 0.43116879543507247 0.5367027419371582 0.3496508195058458 0.6641286400409949 0.8920457696393985 0.4851300688183495 0.41885501224334354 0.5769036162214422 0.16266891018053314 0.8489929248560089 0.03950961686579439 0.3973619293372369 0.9188798403719065 0.2502571609807334 0.6539937363080564 0.4962670216267314 0.5059397155529628 0.22328271944687278 0.8978511372541098 0.440324562490591 0.15741383872444525 0.8035943113334371 0.5393466233077396 0.48745080174403416 0.6764301744781996 0.0971344506314666 0.6310738243741427 0.8054008238118158 0.8884949011513869 0.13246374601957156 0.6782562726703589 0.3805096007520512 0.3973976176183626 0.7446140195142739 0.2405262389043835 0.6492747061872384 0.530835679789699 0.5337766362983298 0.33335135752959427 0.9417563116955688 0.6687155806808092 0.6141212482268387 0.10044388864272068 0.736941918240752 0.8019073620474103 0.9587253275489906 0.3592570635662546 0.21020008849017338 0.238704883006783 0.7446093982916501 0.7867486845455108 0.1519520509093107 0.8062923770515106 0.20607932322859637 0.5661100252831541 0.37105154873999124 0.8126495085892258 0.7462698868406376 0.14682495807637452 0.888762101323832 0.6667498325309713 0.33743078324465225 0.18189374018813248 0.21253081450710226 0.4457890660423582 0.42100346725620974 0.1853399857605621 0.6818923534488163 0.052277745776395775 0.9668168927856104 0.48056582264707576 0.685070584872869) '(-1.49367894324228 -1.223812804042944 1.4727397942407796 -0.5349931410234294 4.928700290487521 4.339011515190846 -1.0049936659727128 4.886099491056241 3.280092791244561 -1.9398893731457916 1.8012692533457075 -2.1729256532582 3.7373283668185184 -3.9789317342991604 -3.1580384041332423 -3.7998312130567267 -3.9911278318448513 -4.701755176674118 -0.978658918251579 -2.90905229357826 -2.348535335340603 3.0455402807249516 3.660579135009236 0.81164670327985 1.054708987576345 -0.5506416327331989 -0.11697880014214412 1.3596020757399536 -0.2616689265922991 -1.4769051903428605 -4.21056037621677 -0.9873324930431924 -1.2850297545735345 0.30284867678368244 -3.674596508358785 3.1549136306250727 1.0336295255154928 0.7106759133016238 -3.3569700799080917 -3.31446258037251 0.8468396698065837 -4.460386204459493 -4.855466484754284 3.3979015767535223 -3.2126103867080253 0.08834506401483821 3.4468117327369967 -4.337591546285137 -0.055267857490606254 -2.770873602052915 1.9902414772477774 4.443140755301604 4.7001399094241485 -2.7088359328151417 4.925435576449029 3.334821254638623 3.1703038479579675 0.9268485865124472 -3.33032393517033 -2.0888062512293577 1.97486027511742 -4.935491233943945 -4.141272789130495 -1.2527211871980155 -2.08501452037136 1.2429845449384018 -3.3635671778834744 0.5165157942408989 3.988341500960926 0.35693635299231197 3.045987110670632 -2.6025208041118844 -4.671322758628657 -0.22783751641928696 2.378326556418699 4.691010582616572 -0.8807835651203684 -2.48388129749127 -2.579786139688988 -0.8817762246015972 0.6121266179012625 0.047074733389679935 1.760996313320467 -4.964357539945016 3.485998247724023 -3.234732352634393 -2.937420323374533) '(82.05120399976373 263.91630519910956 297.22926478316873 146.08878945203273 327.40923055896394 250.9470943565426 156.25255248742653 189.6130522147064 258.3695204153089 11.711020789502227 214.624087390721 7.046797437680508 33.776565331549506 218.6740701248386 111.06953120058316 331.07636215365744 211.05798790428412 160.57747706878462 348.3386041006793 304.4352291979552 116.55262693120656 312.63073696313563 240.00122666359178 359.97510977084767 252.608976313116 152.88827850090019 124.25799452561513 190.9637784789573 116.31504423229964 295.31677800289685 24.045472785915198 297.5281031011196 318.8344711788641 292.2962780525839 203.29763234275882 189.02762120408497 313.8065972808871 63.358272432085634 232.26165621031384 92.08916338549771 209.6222154975351 170.79154895765996 7.283545969582248 29.382963458789444 233.13468708309287 149.2263376512124 206.73332282664873 89.10618016329813 324.0893256740446 256.93863901670767 157.3398435811323 90.15113728149075 82.76663966992244 196.64842143030543 176.2518861447496 23.63236565819451 184.2185337547558 107.79907015673643 147.717011026511 184.90427267719858 128.03349205857793 132.2780569871479 351.62539175083003 102.34744277288661 163.2834296734695 192.37794971536462 57.43041615454558 262.1350307429862 153.12637417228217 312.49314500483337 300.60325507186957 285.3394687275206 184.37701341580043 352.92131579093876 290.13910809557717 111.05576677444535 280.60062095634754 33.8506512974401 99.59026332868312 197.51166291071414 162.1609359274822 250.918253233504 40.08758857862575 56.21392439345629 263.01204469615976 27.86162120823119 266.3881499066728) 8 250)
