;;; Canons stochastiques effectuant des tirages parmi un ensemble fini
;;; d'vnements donns,  partir de probabilits donnes

;;   Gestion du module "canons-stochastiques", ncessaire pour la fonction
;; init-random (ainsi que frandom, si utilise).

(when (not (boundp 'common-lisp::*path-stochastique*))
	(setq common-lisp::*path-stochastique* (pathname ""))
	(format *error-output*
		"Attention : le path common-lisp::*path-stochastique* est nul :~
		~%~12Terreur(s) fichier(s) possible(s)."))
(require "canons-stochastiques"
	(merge-pathnames "canons_base.lisp" common-lisp::*path-stochastique*))

(defun alter2 (a b pdea)
"
;    alter2 <a> <b> <pdea> => choix entre <a>, de probabilite <pdea>, et <b>, de
;                             probabilite (1-<pdea>)
"
  (if (<= (random 1.0) pdea) a b))
 
(defun altern (boul prob)
"
;    altern <boul> <prob> => choix d'un element de la liste <boul>, selon les
;        probabilites respectives donnees dans la liste <prob>.
;        On ne verifie pas si <boul> et <prob> ont la meme list-length, ni si
;        la somme des elements de la liste <prob> est egale a 1.0
"
  (let ((u (random 1.0)))
    (do* ((n 0 (1+ n))
          (som (nth 0 prob) (+ som (nth n prob))))
         ((< u som) (nth n boul)))))

(defun equiprob (boul)
"
;    equiprob <boul> => choix d'un element de la liste <boul>, selon des
;        probabilites gales
"
  (let ((u (random 1.0))
        (p (/ 1.0 (list-length boul))))
    (do ((n 0 (1+ n))
         (som 0 (+ som p)))
        ((< u som) (nth (1- n) boul)))))

;;   Cf. Cours LISP, Chapitre 14.

(defun permuter (obj)
"
;    permuter <liste> => rend une copie permutee des elements de <liste>. Toutes
;                        les permutations sont equiprobables
"
  (let ((perm ())
        (trav (list 0))
        (ic (1- (list-length obj)))
        (ix 0))
    (do () ((= ix ic)) (nconc trav (list (incf ix))))
    (do () ((< ic 0))
      (setq ix (random (1+ ic)))
      (push (nth (nth ix trav) obj) perm)
      (setf (car (nthcdr ix trav)) (nth ic trav))
      (decf ic))
    perm))

;;   Choisit un INDICE, selon le vecteur de probabilits KPVPROBA.
;;   Mais la somme de ces probabilits n'est pas ncessairement 1 : cette somme
;; est dans (car KPVPROBA).  KPVPROBA a donc un lment de plus que le nombre
;; d'INDICES possibles.
;;   Rend un INDICE dans [0,(- (length kpvproba) 2)].
;;   EFFET DE BORD : INCRMENT est AJOUT au (car KPVPROBA) ET  la probabilit
;; de l'indice choisi. Si l'on veut garder le vecteur original de probabilits :
;;    appeler indisredon+ aprs un
;;        (setq kpvprobX (copy <vecteur-original-a-conserver>))
;; Appel type :
;;    (nth (indisredon+ kopivproba 0.06) <liste-d-objets-a-choisir>)

(defun indisredon+ (kpvproba increment)
"
;   Voir fichier de dfinition
"
  (let ((u (corect 0.0 (car kpvproba))))
    (do* ((n 1 (1+ n))
          (cumul (cadr kpvproba) (+ cumul (nth n kpvproba))))
         ((< u cumul)
          (rplaca (nthcdr n kpvproba) (+ (nth n kpvproba) increment))
          (rplaca kpvproba (+ (car kpvproba) increment))
          (1- n)))))

;;   Choisit un INDICE, selon le vecteur de probabilites KPVPROBA.
;;   Mais la somme de ces probabilits n'est pas ncessairement 1 : cette somme
;; est dans (car KPVPROBA).  KPVPROBA a donc un lment de plus que le nombre
;; d'INDICES possibles.
;;   Rend un INDICE dans [0,(- (length kpvproba) 2)].
;;   EFFET DE BORD: FACTCONV MULTIPLIE la probabilit de l'indice choisi, et le
;; (car kpvproba) est augment d'autant. Si l'on veut garder le vecteur original
;; de probabilits :
;;    appeler indisredon* aprs un
;;        (setq kpvproba (copy <vecteur-original-a-conserver>))
;; Appel type :
;;    (nth (indisredon* kopivprob 1.02) <liste-d-objets-a-choisir>)

(defun indisredon* (kpvproba factconv)
"
;   Voir fichier de dfinition
"
  (let ((u (corect 0.0 (car kpvproba))))
    (do* ((n 1 (1+ n))
          (cumul (cadr kpvproba) (+ cumul (nth n kpvproba))))
         ((< u cumul)
          (rplaca (nthcdr n kpvproba) (* (nth n kpvproba) factconv))
          (rplaca kpvproba (sigma (cdr kpvproba)))
          (1- n)))))

(defun sigma (lis)
"
;    sigma <liste-de-nombres-quelconques> => somme des nombres de la liste
"
  (apply #'+ lis))

;;   "Documentation".

(setq Doc.Stoch (concatenate 'string Doc.Stoch
                                     (format nil ";; canons_tirj
;    alter2 <a> <b> <pdea>     => chx <a>, prob. <pdea>, ou <b>, prob. (1-<pdea>)
;    altern <boul> <prob>      => chx dans liste <boul>, selon probs. liste <prob>
;    equiprob <boul>           => chx dans liste <boul>, selon probs. egales
;    permuter <liste>          => copie permutee de <liste>
;    sigma <liste-de-nbrs>     => somme des nombres de la liste
;    indisredon+ & indisredon* : cf. definition
")))

;(format t "~A" Doc.Stoch)
