;;   Cration automatique d'un nom de fichier. Le rsultat est un path complet
;; dsignant, dans le mme dossier, un fichier de mme nom avec une nouvelle
;; extension ".<extension>".
;; Exemple d'appel, depuis le fichier #P"Volume:dossier1:dossier2:truc.cl" :
;;    (make-file-name *load-truename* "sco")
;;        => #P"Volume:dossier1:dossier2:truc.sco"
;; Evidemment, ceci ne fonctionne correctement que si l'appel est intgr  un
;; fichier charg -- par (load ...) ou son quivalent -- et non pas valu
;; manuellement.

(defun make-file-name (vrai-nom extension)
  (let ((fichier (pathname-name vrai-nom));enlve dj extension orig. si existe
        (dossier (merge-pathnames
                  (make-pathname :directory
                                 (pathname-directory vrai-nom)) "*")))
    (merge-pathnames (make-pathname :name fichier :type extension)
                     dossier)
    ))

;;   Exemples : enlever les ; de commentaires des formes ci-dessous, et charger
;; le prsent fichier.
;     (print (make-file-name *load-truename* "sco"))
;;        => #P"DD:1DLO:cl.d:utilitaires.d:make-file-name.sco"
;;   Exemple complet de cration et criture d'un fichier du mme nom que le
;; prsent, mais avec changement de l'extension (*type* pour Common LISP) de
;; ".lisp"  ".sco" :
;     (with-open-file (flux (make-file-name *load-truename* "sco")
;                             :direction         :output
;                             :if-does-not-exist :create
;                             :if-exists         :rename-and-delete)
;       (format flux "Ceci sera dans le fichier...~%"))
