;; A partir d'une chane de caractres, donne une liste de sous-chanes, ou <mots>.
;; Un <mot> est compos d'un ou plusieurs caractres non-sparateurs, spars par
;; un ou plusieurs caractres sparateurs. La key :separateurs permet de modifier
;; la liste des caractres dfinis comme sparateurs.
;; Ex. : (separer-mots "    ")                   ==> nil
;;       (separer-mots " C'est lui ! Non ? ")    ==> ("C" "est" "lui" "Non")
;; Fait pour "CRIM" (Christian Morales-Ossio), 20/12/97.
(defun separer-mots (cadena
     &key (separateurs
               '(#\space #\newline #\tab #\return #\linefeed #\page ;blancs
                 #\, #\. #\; #\: #\! #\?                            ;ponctuations
                 #\- #\' #\( #\) #\" #\/                            ;grammaticaux
                ))  )
  (do ( (rez    ()                    )
        (mot    ""                    )
        (caract nil                   )
        (long   (length cadena)       )
        (n      0               (1+ n)) )
      ( (= n long) (if (string= "" mot) rez
                       (append rez (list mot))) )
    (if (member (setq caract (char cadena n)) separateurs)
      (when (not (string= "" mot))
        (setq rez (append rez (list mot)))
        (setq mot ""))
      (setq mot (concatenate 'string mot (string caract))))))